/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import adsi.org.apache.xml.security.Init;
import adsi.org.apache.xml.security.exceptions.Base64DecodingException;
import adsi.org.apache.xml.security.utils.Base64;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.Manifest;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignContext;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLValidateContext;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import org.jcp.xml.dsig.internal.dom.DOMKeyInfo;
import org.jcp.xml.dsig.internal.dom.DOMReference;
import org.jcp.xml.dsig.internal.dom.DOMSignatureMethod;
import org.jcp.xml.dsig.internal.dom.DOMSignedInfo;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.jcp.xml.dsig.internal.dom.DOMXMLObject;
import org.jcp.xml.dsig.internal.dom.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DOMXMLSignature
extends DOMStructure
implements XMLSignature {
    private static Logger log = Logger.getLogger("org.jcp.xml.dsig.internal.dom");
    private String id;
    private XMLSignature.SignatureValue sv;
    private KeyInfo ki;
    private List objects;
    private SignedInfo si;
    private Document ownerDoc = null;
    private Element localSigElem = null;
    private Element sigElem = null;
    private boolean validationStatus;
    private boolean validated = false;
    private KeySelectorResult ksr;
    private HashMap signatureIdMap;

    static {
        Init.init();
    }

    public DOMXMLSignature(SignedInfo si, KeyInfo ki, List objs, String id, String signatureValueId) {
        if (si == null) {
            throw new NullPointerException("signedInfo cannot be null");
        }
        this.si = si;
        this.id = id;
        this.sv = new DOMSignatureValue(signatureValueId);
        if (objs == null) {
            this.objects = Collections.EMPTY_LIST;
        } else {
            ArrayList objsCopy = new ArrayList(objs);
            int i = 0;
            int size = objsCopy.size();
            while (i < size) {
                if (!(objsCopy.get(i) instanceof XMLObject)) {
                    throw new ClassCastException("objs[" + i + "] is not an XMLObject");
                }
                ++i;
            }
            this.objects = Collections.unmodifiableList(objsCopy);
        }
        this.ki = ki;
    }

    public DOMXMLSignature(Element sigElem, XMLCryptoContext context, Provider provider) throws MarshalException {
        this.localSigElem = sigElem;
        this.ownerDoc = this.localSigElem.getOwnerDocument();
        this.id = DOMUtils.getAttributeValue(this.localSigElem, "Id");
        Element siElem = DOMUtils.getFirstChildElement(this.localSigElem);
        this.si = new DOMSignedInfo(siElem, context, provider);
        Element sigValElem = DOMUtils.getNextSiblingElement(siElem);
        this.sv = new DOMSignatureValue(sigValElem);
        Element nextSibling = DOMUtils.getNextSiblingElement(sigValElem);
        if (nextSibling != null && nextSibling.getLocalName().equals("KeyInfo")) {
            this.ki = new DOMKeyInfo(nextSibling, context, provider);
            nextSibling = DOMUtils.getNextSiblingElement(nextSibling);
        }
        if (nextSibling == null) {
            this.objects = Collections.EMPTY_LIST;
        } else {
            ArrayList<DOMXMLObject> tempObjects = new ArrayList<DOMXMLObject>();
            while (nextSibling != null) {
                tempObjects.add(new DOMXMLObject(nextSibling, context, provider));
                nextSibling = DOMUtils.getNextSiblingElement(nextSibling);
            }
            this.objects = Collections.unmodifiableList(tempObjects);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public KeyInfo getKeyInfo() {
        return this.ki;
    }

    @Override
    public SignedInfo getSignedInfo() {
        return this.si;
    }

    @Override
    public List getObjects() {
        return this.objects;
    }

    @Override
    public XMLSignature.SignatureValue getSignatureValue() {
        return this.sv;
    }

    @Override
    public KeySelectorResult getKeySelectorResult() {
        return this.ksr;
    }

    @Override
    public void marshal(Node parent, String dsPrefix, DOMCryptoContext context) throws MarshalException {
        this.marshal(parent, null, dsPrefix, context);
    }

    public void marshal(Node parent, Node nextSibling, String dsPrefix, DOMCryptoContext context) throws MarshalException {
        this.ownerDoc = DOMUtils.getOwnerDocument(parent);
        this.sigElem = DOMUtils.createElement(this.ownerDoc, "Signature", "http://www.w3.org/2000/09/xmldsig#", dsPrefix);
        if (dsPrefix == null || dsPrefix.length() == 0) {
            this.sigElem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/09/xmldsig#");
        } else {
            this.sigElem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + dsPrefix, "http://www.w3.org/2000/09/xmldsig#");
        }
        ((DOMSignedInfo)this.si).marshal(this.sigElem, dsPrefix, context);
        ((DOMSignatureValue)this.sv).marshal(this.sigElem, dsPrefix, context);
        if (this.ki != null) {
            ((DOMKeyInfo)this.ki).marshal(this.sigElem, null, dsPrefix, context);
        }
        int i = 0;
        int size = this.objects.size();
        while (i < size) {
            ((DOMXMLObject)this.objects.get(i)).marshal(this.sigElem, dsPrefix, context);
            ++i;
        }
        DOMUtils.setAttributeID(this.sigElem, "Id", this.id);
        parent.insertBefore(this.sigElem, nextSibling);
    }

    @Override
    public boolean validate(XMLValidateContext vc) throws XMLSignatureException {
        if (vc == null) {
            throw new NullPointerException("validateContext is null");
        }
        if (!(vc instanceof DOMValidateContext)) {
            throw new ClassCastException("validateContext must be of type DOMValidateContext");
        }
        if (this.validated) {
            return this.validationStatus;
        }
        boolean sigValidity = this.sv.validate(vc);
        if (!sigValidity) {
            this.validationStatus = false;
            this.validated = true;
            return this.validationStatus;
        }
        List refs = this.si.getReferences();
        boolean validateRefs = true;
        int i = 0;
        int size = refs.size();
        while (validateRefs && i < size) {
            Reference ref = (Reference)refs.get(i);
            boolean refValid = ref.validate(vc);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Reference[" + ref.getURI() + "] is valid: " + refValid);
            }
            validateRefs &= refValid;
            ++i;
        }
        if (!validateRefs) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Couldn't validate the References");
            }
            this.validationStatus = false;
            this.validated = true;
            return this.validationStatus;
        }
        boolean validateMans = true;
        if (Boolean.TRUE.equals(vc.getProperty("org.jcp.xml.dsig.validateManifests"))) {
            int i2 = 0;
            int size2 = this.objects.size();
            while (validateMans && i2 < size2) {
                XMLObject xo = (XMLObject)this.objects.get(i2);
                List content = xo.getContent();
                int csize = content.size();
                int j = 0;
                while (validateMans && j < csize) {
                    XMLStructure xs = (XMLStructure)content.get(j);
                    if (xs instanceof Manifest) {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "validating manifest");
                        }
                        Manifest man = (Manifest)xs;
                        List manRefs = man.getReferences();
                        int rsize = manRefs.size();
                        int k = 0;
                        while (validateMans && k < rsize) {
                            Reference ref = (Reference)manRefs.get(k);
                            boolean refValid = ref.validate(vc);
                            if (log.isLoggable(Level.FINE)) {
                                log.log(Level.FINE, "Manifest ref[" + ref.getURI() + "] is valid: " + refValid);
                            }
                            validateMans &= refValid;
                            ++k;
                        }
                    }
                    ++j;
                }
                ++i2;
            }
        }
        this.validationStatus = validateMans;
        this.validated = true;
        return this.validationStatus;
    }

    @Override
    public void sign(XMLSignContext signContext) throws MarshalException, XMLSignatureException {
        Reference ref;
        if (signContext == null) {
            throw new NullPointerException("signContext cannot be null");
        }
        DOMSignContext context = (DOMSignContext)signContext;
        if (context != null) {
            this.marshal(context.getParent(), context.getNextSibling(), DOMUtils.getSignaturePrefix(context), context);
        }
        ArrayList<Reference> allReferences = new ArrayList<Reference>(this.si.getReferences());
        this.signatureIdMap = new HashMap();
        this.signatureIdMap.put(this.id, this);
        this.signatureIdMap.put(this.si.getId(), this.si);
        List refs = this.si.getReferences();
        int i = 0;
        int size = refs.size();
        while (i < size) {
            ref = (Reference)refs.get(i);
            this.signatureIdMap.put(ref.getId(), ref);
            ++i;
        }
        i = 0;
        size = this.objects.size();
        while (i < size) {
            XMLObject obj = (XMLObject)this.objects.get(i);
            this.signatureIdMap.put(obj.getId(), obj);
            List content = obj.getContent();
            int j = 0;
            int csize = content.size();
            while (j < csize) {
                XMLStructure xs = (XMLStructure)content.get(j);
                if (xs instanceof Manifest) {
                    Manifest man = (Manifest)xs;
                    this.signatureIdMap.put(man.getId(), man);
                    List manRefs = man.getReferences();
                    int k = 0;
                    int msize = manRefs.size();
                    while (k < msize) {
                        Reference ref2 = (Reference)manRefs.get(k);
                        allReferences.add(ref2);
                        this.signatureIdMap.put(ref2.getId(), ref2);
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        size = allReferences.size();
        while (i < size) {
            ref = (DOMReference)allReferences.get(i);
            this.digestReference((DOMReference)ref, signContext);
            ++i;
        }
        i = 0;
        size = allReferences.size();
        while (i < size) {
            ref = (DOMReference)allReferences.get(i);
            if (!((DOMReference)ref).isDigested()) {
                ((DOMReference)ref).digest(signContext);
            }
            ++i;
        }
        Key signingKey = null;
        KeySelectorResult ksr = null;
        try {
            ksr = signContext.getKeySelector().select(this.ki, KeySelector.Purpose.SIGN, this.si.getSignatureMethod(), signContext);
            signingKey = ksr.getKey();
            if (signingKey == null) {
                throw new XMLSignatureException("the keySelector did not find a signing key");
            }
        }
        catch (KeySelectorException kse) {
            throw new XMLSignatureException("cannot find signing key", kse);
        }
        byte[] val = null;
        try {
            val = ((DOMSignatureMethod)this.si.getSignatureMethod()).sign(signingKey, (DOMSignedInfo)this.si, signContext);
        }
        catch (InvalidKeyException ike) {
            throw new XMLSignatureException(ike);
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "SignatureValue = " + val);
        }
        ((DOMSignatureValue)this.sv).setValue(val);
        this.localSigElem = this.sigElem;
        this.ksr = ksr;
    }

    public boolean equals(Object o) {
        boolean keyInfoEqual;
        boolean idEqual;
        if (this == o) {
            return true;
        }
        if (!(o instanceof XMLSignature)) {
            return false;
        }
        XMLSignature osig = (XMLSignature)o;
        boolean bl = this.id == null ? osig.getId() == null : (idEqual = this.id.equals(osig.getId()));
        boolean bl2 = this.ki == null ? osig.getKeyInfo() == null : (keyInfoEqual = this.ki.equals(osig.getKeyInfo()));
        return idEqual && keyInfoEqual && this.sv.equals(osig.getSignatureValue()) && this.si.equals(osig.getSignedInfo()) && this.objects.equals(osig.getObjects());
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 54;
    }

    private void digestReference(DOMReference ref, XMLSignContext signContext) throws XMLSignatureException {
        if (ref.isDigested()) {
            return;
        }
        String uri = ref.getURI();
        if (Utils.sameDocumentURI(uri)) {
            String id = Utils.parseIdFromSameDocumentURI(uri);
            if (id != null && this.signatureIdMap.containsKey(id)) {
                Object obj = this.signatureIdMap.get(id);
                if (obj instanceof DOMReference) {
                    this.digestReference((DOMReference)obj, signContext);
                } else if (obj instanceof Manifest) {
                    Manifest man = (Manifest)obj;
                    List manRefs = man.getReferences();
                    int i = 0;
                    int size = manRefs.size();
                    while (i < size) {
                        this.digestReference((DOMReference)manRefs.get(i), signContext);
                        ++i;
                    }
                }
            }
            if (uri.length() == 0) {
                List transforms = ref.getTransforms();
                int i = 0;
                int size = transforms.size();
                while (i < size) {
                    Transform transform = (Transform)transforms.get(i);
                    String transformAlg = transform.getAlgorithm();
                    if (transformAlg.equals("http://www.w3.org/TR/1999/REC-xpath-19991116") || transformAlg.equals("http://www.w3.org/2002/06/xmldsig-filter2")) {
                        return;
                    }
                    ++i;
                }
            }
        }
        ref.digest(signContext);
    }

    public class DOMSignatureValue
    extends DOMStructure
    implements XMLSignature.SignatureValue {
        private String id;
        private byte[] value;
        private String valueBase64;
        private Element sigValueElem;
        private boolean validated = false;
        private boolean validationStatus;

        DOMSignatureValue(String id) {
            this.id = id;
        }

        DOMSignatureValue(Element sigValueElem) throws MarshalException {
            try {
                this.value = Base64.decode(sigValueElem);
            }
            catch (Base64DecodingException bde) {
                throw new MarshalException(bde);
            }
            this.id = DOMUtils.getAttributeValue(sigValueElem, "Id");
            this.sigValueElem = sigValueElem;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public byte[] getValue() {
            return this.value == null ? null : (byte[])this.value.clone();
        }

        @Override
        public boolean validate(XMLValidateContext validateContext) throws XMLSignatureException {
            KeySelectorResult ksResult;
            if (validateContext == null) {
                throw new NullPointerException("context cannot be null");
            }
            if (this.validated) {
                return this.validationStatus;
            }
            SignatureMethod sm = DOMXMLSignature.this.si.getSignatureMethod();
            Key validationKey = null;
            try {
                ksResult = validateContext.getKeySelector().select(DOMXMLSignature.this.ki, KeySelector.Purpose.VERIFY, sm, validateContext);
                validationKey = ksResult.getKey();
                if (validationKey == null) {
                    throw new XMLSignatureException("the keyselector did not find a validation key");
                }
            }
            catch (KeySelectorException kse) {
                throw new XMLSignatureException("cannot find validation key", kse);
            }
            try {
                this.validationStatus = ((DOMSignatureMethod)sm).verify(validationKey, (DOMSignedInfo)DOMXMLSignature.this.si, this.value, validateContext);
            }
            catch (Exception e) {
                throw new XMLSignatureException(e);
            }
            this.validated = true;
            DOMXMLSignature.this.ksr = ksResult;
            return this.validationStatus;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof XMLSignature.SignatureValue)) {
                return false;
            }
            XMLSignature.SignatureValue osv = (XMLSignature.SignatureValue)o;
            boolean idEqual = this.id == null ? osv.getId() == null : this.id.equals(osv.getId());
            return idEqual;
        }

        public int hashCode() {
            return 55;
        }

        @Override
        public void marshal(Node parent, String dsPrefix, DOMCryptoContext context) throws MarshalException {
            this.sigValueElem = DOMUtils.createElement(DOMXMLSignature.this.ownerDoc, "SignatureValue", "http://www.w3.org/2000/09/xmldsig#", dsPrefix);
            if (this.valueBase64 != null) {
                this.sigValueElem.appendChild(DOMXMLSignature.this.ownerDoc.createTextNode(this.valueBase64));
            }
            DOMUtils.setAttributeID(this.sigValueElem, "Id", this.id);
            parent.appendChild(this.sigValueElem);
        }

        void setValue(byte[] value) {
            this.value = value;
            this.valueBase64 = Base64.encode(value);
            this.sigValueElem.appendChild(DOMXMLSignature.this.ownerDoc.createTextNode(this.valueBase64));
        }
    }
}

