/*
 * Decompiled with CFR 0.152.
 */
package adsi.org.apache.xml.security.utils.resolver.implementations;

import adsi.org.apache.xml.security.signature.XMLSignatureInput;
import adsi.org.apache.xml.security.utils.IdResolver;
import adsi.org.apache.xml.security.utils.resolver.ResourceResolverException;
import adsi.org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ResolverFragment
extends ResourceResolverSpi {
    static Log log = LogFactory.getLog((String)ResolverFragment.class.getName());

    @Override
    public boolean engineIsThreadSafe() {
        return true;
    }

    @Override
    public XMLSignatureInput engineResolve(Attr uri, String BaseURI) throws ResourceResolverException {
        String uriNodeValue = uri.getNodeValue();
        Document doc = uri.getOwnerElement().getOwnerDocument();
        Node selectedElem = null;
        if (uriNodeValue.equals("")) {
            log.debug((Object)"ResolverFragment with empty URI (means complete document)");
            selectedElem = doc;
        } else {
            String id = uriNodeValue.substring(1);
            selectedElem = IdResolver.getElementById(doc, id);
            if (selectedElem == null) {
                Object[] exArgs = new Object[]{id};
                throw new ResourceResolverException("signature.Verification.MissingID", exArgs, uri, BaseURI);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Try to catch an Element with ID " + id + " and Element was " + selectedElem));
            }
        }
        XMLSignatureInput result = new XMLSignatureInput(selectedElem);
        result.setExcludeComments(true);
        result.setMIMEType("text/xml");
        result.setSourceURI(BaseURI != null ? BaseURI.concat(uri.getNodeValue()) : uri.getNodeValue());
        return result;
    }

    @Override
    public boolean engineCanResolve(Attr uri, String BaseURI) {
        if (uri == null) {
            log.debug((Object)"Quick fail for null uri");
            return false;
        }
        String uriNodeValue = uri.getNodeValue();
        if (uriNodeValue.equals("") || uriNodeValue.charAt(0) == '#' && (uriNodeValue.charAt(1) != 'x' || !uriNodeValue.startsWith("#xpointer("))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("State I can resolve reference: \"" + uriNodeValue + "\""));
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Do not seem to be able to resolve reference: \"" + uriNodeValue + "\""));
        }
        return false;
    }
}

