/*
 * Decompiled with CFR 0.152.
 */
package adsi.org.apache.xml.security.utils;

import adsi.org.apache.xml.security.exceptions.XMLSecurityException;
import adsi.org.apache.xml.security.utils.ElementChecker;
import adsi.org.apache.xml.security.utils.ElementProxy;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class ElementCheckerImpl
implements ElementChecker {
    @Override
    public boolean isNamespaceElement(Node el, String type, String ns) {
        return el != null && ns == el.getNamespaceURI() && el.getLocalName().equals(type);
    }

    public static class EmptyChecker
    extends ElementCheckerImpl {
        @Override
        public void guaranteeThatElementInCorrectSpace(ElementProxy expected, Element actual) throws XMLSecurityException {
        }
    }

    public static class FullChecker
    extends ElementCheckerImpl {
        @Override
        public void guaranteeThatElementInCorrectSpace(ElementProxy expected, Element actual) throws XMLSecurityException {
            String localnameSHOULDBE = expected.getBaseLocalName();
            String namespaceSHOULDBE = expected.getBaseNamespace();
            String localnameIS = actual.getLocalName();
            String namespaceIS = actual.getNamespaceURI();
            if (!namespaceSHOULDBE.equals(namespaceIS) || !localnameSHOULDBE.equals(localnameIS)) {
                Object[] exArgs = new Object[]{String.valueOf(namespaceIS) + ":" + localnameIS, String.valueOf(namespaceSHOULDBE) + ":" + localnameSHOULDBE};
                throw new XMLSecurityException("xml.WrongElement", exArgs);
            }
        }
    }

    public static class InternedNsChecker
    extends ElementCheckerImpl {
        @Override
        public void guaranteeThatElementInCorrectSpace(ElementProxy expected, Element actual) throws XMLSecurityException {
            String localnameSHOULDBE = expected.getBaseLocalName();
            String namespaceSHOULDBE = expected.getBaseNamespace();
            String localnameIS = actual.getLocalName();
            String namespaceIS = actual.getNamespaceURI();
            if (namespaceSHOULDBE != namespaceIS || !localnameSHOULDBE.equals(localnameIS)) {
                Object[] exArgs = new Object[]{String.valueOf(namespaceIS) + ":" + localnameIS, String.valueOf(namespaceSHOULDBE) + ":" + localnameSHOULDBE};
                throw new XMLSecurityException("xml.WrongElement", exArgs);
            }
        }
    }
}

