/*
 * Decompiled with CFR 0.152.
 */
package adsi.org.apache.xml.security.transforms.implementations;

import adsi.org.apache.xml.security.exceptions.XMLSecurityException;
import adsi.org.apache.xml.security.signature.XMLSignatureInput;
import adsi.org.apache.xml.security.transforms.Transform;
import adsi.org.apache.xml.security.transforms.TransformSpi;
import adsi.org.apache.xml.security.transforms.TransformationException;
import adsi.org.apache.xml.security.utils.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class TransformXSLT
extends TransformSpi {
    public static final String implementedTransformURI = "http://www.w3.org/TR/1999/REC-xslt-19991116";
    static final String XSLTSpecNS = "http://www.w3.org/1999/XSL/Transform";
    static final String defaultXSLTSpecNSprefix = "xslt";
    static final String XSLTSTYLESHEET = "stylesheet";
    private static Class xClass = null;
    static Log log;

    static {
        try {
            xClass = Class.forName("javax.xml.XMLConstants");
        }
        catch (Exception exception) {
            // empty catch block
        }
        log = LogFactory.getLog((String)TransformXSLT.class.getName());
    }

    @Override
    protected String engineGetURI() {
        return implementedTransformURI;
    }

    @Override
    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput input, Transform _transformObject) throws IOException, TransformationException {
        return this.enginePerformTransform(input, null, _transformObject);
    }

    @Override
    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput input, OutputStream baos, Transform _transformObject) throws IOException, TransformationException {
        if (xClass == null) {
            Object[] exArgs = new Object[]{"SECURE_PROCESSING_FEATURE not supported"};
            throw new TransformationException("generic.EmptyMessage", exArgs);
        }
        try {
            Element transformElement = _transformObject.getElement();
            Element _xsltElement = XMLUtils.selectNode(transformElement.getFirstChild(), XSLTSpecNS, XSLTSTYLESHEET, 0);
            if (_xsltElement == null) {
                Object[] exArgs = new Object[]{"xslt:stylesheet", "Transform"};
                throw new TransformationException("xml.WrongContent", exArgs);
            }
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Class<?> c = tFactory.getClass();
            Method m = c.getMethod("setFeature", String.class, Boolean.TYPE);
            m.invoke((Object)tFactory, "http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
            StreamSource xmlSource = new StreamSource(new ByteArrayInputStream(input.getBytes()));
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(_xsltElement);
            StreamResult result = new StreamResult(os);
            transformer.transform(source, result);
            StreamSource stylesheet = new StreamSource(new ByteArrayInputStream(os.toByteArray()));
            Transformer transformer2 = tFactory.newTransformer(stylesheet);
            try {
                transformer2.setOutputProperty("{http://xml.apache.org/xalan}line-separator", "\n");
            }
            catch (Exception e) {
                log.warn((Object)("Unable to set Xalan line-separator property: " + e.getMessage()));
            }
            if (baos == null) {
                ByteArrayOutputStream baos1 = new ByteArrayOutputStream();
                StreamResult outputTarget = new StreamResult(baos1);
                transformer2.transform(xmlSource, outputTarget);
                return new XMLSignatureInput(baos1.toByteArray());
            }
            StreamResult outputTarget = new StreamResult(baos);
            transformer2.transform(xmlSource, outputTarget);
            XMLSignatureInput output = new XMLSignatureInput(null);
            output.setOutputStream(baos);
            return output;
        }
        catch (XMLSecurityException ex) {
            Object[] exArgs = new Object[]{ex.getMessage()};
            throw new TransformationException("generic.EmptyMessage", exArgs, ex);
        }
        catch (TransformerConfigurationException ex) {
            Object[] exArgs = new Object[]{ex.getMessage()};
            throw new TransformationException("generic.EmptyMessage", exArgs, ex);
        }
        catch (TransformerException ex) {
            Object[] exArgs = new Object[]{ex.getMessage()};
            throw new TransformationException("generic.EmptyMessage", exArgs, ex);
        }
        catch (NoSuchMethodException ex) {
            Object[] exArgs = new Object[]{ex.getMessage()};
            throw new TransformationException("generic.EmptyMessage", exArgs, ex);
        }
        catch (IllegalAccessException ex) {
            Object[] exArgs = new Object[]{ex.getMessage()};
            throw new TransformationException("generic.EmptyMessage", exArgs, ex);
        }
        catch (InvocationTargetException ex) {
            Object[] exArgs = new Object[]{ex.getMessage()};
            throw new TransformationException("generic.EmptyMessage", exArgs, ex);
        }
    }
}

