/*
 * Decompiled with CFR 0.152.
 */
package adsi.org.apache.xml.security.keys.keyresolver.implementations;

import adsi.org.apache.xml.security.exceptions.XMLSecurityException;
import adsi.org.apache.xml.security.keys.content.keyvalues.RSAKeyValue;
import adsi.org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import adsi.org.apache.xml.security.keys.storage.StorageResolver;
import adsi.org.apache.xml.security.utils.XMLUtils;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class RSAKeyValueResolver
extends KeyResolverSpi {
    static Log log = LogFactory.getLog((String)RSAKeyValueResolver.class.getName());

    @Override
    public PublicKey engineLookupAndResolvePublicKey(Element element, String BaseURI, StorageResolver storage) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Can I resolve " + element.getTagName()));
        }
        if (element == null) {
            return null;
        }
        boolean isKeyValue = XMLUtils.elementIsInSignatureSpace(element, "KeyValue");
        Element rsaKeyElement = null;
        if (isKeyValue) {
            rsaKeyElement = XMLUtils.selectDsNode(element.getFirstChild(), "RSAKeyValue", 0);
        } else if (XMLUtils.elementIsInSignatureSpace(element, "RSAKeyValue")) {
            rsaKeyElement = element;
        }
        if (rsaKeyElement == null) {
            return null;
        }
        try {
            RSAKeyValue rsaKeyValue = new RSAKeyValue(rsaKeyElement, BaseURI);
            return rsaKeyValue.getPublicKey();
        }
        catch (XMLSecurityException ex) {
            log.debug((Object)"XMLSecurityException", (Throwable)ex);
            return null;
        }
    }

    @Override
    public X509Certificate engineLookupResolveX509Certificate(Element element, String BaseURI, StorageResolver storage) {
        return null;
    }

    @Override
    public SecretKey engineLookupAndResolveSecretKey(Element element, String BaseURI, StorageResolver storage) {
        return null;
    }
}

