/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.io.EOFException;
import java.io.InputStream;
import java.net.SocketException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Calendar;
import java.util.Date;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.BOOLEAN;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.InternalCertificate;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.pkix.cert.Certificate;
import org.mozilla.jss.pkix.cert.CertificateInfo;
import org.mozilla.jss.pkix.cert.Extension;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.Name;
import org.mozilla.jss.pkix.primitive.SubjectPublicKeyInfo;
import org.mozilla.jss.ssl.SSLHandshakeCompletedEvent;
import org.mozilla.jss.ssl.SSLHandshakeCompletedListener;
import org.mozilla.jss.ssl.SSLSecurityStatus;
import org.mozilla.jss.ssl.SSLServerSocket;
import org.mozilla.jss.ssl.SSLSocket;
import org.mozilla.jss.tests.FilePasswordCallback;

public class SSLClientAuth
implements Runnable {
    private CryptoManager cm;
    public static final SignatureAlgorithm sigAlg = SignatureAlgorithm.RSASignatureWithSHA1Digest;
    private X509Certificate nssServerCert;
    private X509Certificate nssClientCert;
    private String serverCertNick;
    private String clientCertNick;
    private boolean useNickname;
    private boolean success = true;
    public int port = 29752;
    public boolean serverReady = false;

    public static Certificate makeCert(String string, String string2, int n, PrivateKey privateKey, PublicKey publicKey, int n2, SEQUENCE sEQUENCE) throws Exception {
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(sigAlg.toOID());
        Name name = new Name();
        name.addCommonName(string);
        name.addCountryName("US");
        name.addOrganizationName("Mozilla" + n2);
        name.addOrganizationalUnitName("JSS Testing");
        Name name2 = new Name();
        name2.addCommonName(string2);
        name2.addCountryName("US");
        name2.addOrganizationName("Mozilla" + n2);
        name2.addOrganizationalUnitName("JSS Testing");
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        calendar.add(1, 1);
        Date date2 = calendar.getTime();
        SubjectPublicKeyInfo.Template template = new SubjectPublicKeyInfo.Template();
        SubjectPublicKeyInfo subjectPublicKeyInfo = (SubjectPublicKeyInfo)ASN1Util.decode(template, publicKey.getEncoded());
        CertificateInfo certificateInfo = new CertificateInfo(CertificateInfo.v3, new INTEGER(n), algorithmIdentifier, name, date, date2, name2, subjectPublicKeyInfo);
        if (sEQUENCE != null) {
            certificateInfo.setExtensions(sEQUENCE);
        }
        return new Certificate(certificateInfo, privateKey, sigAlg);
    }

    public static void main(String[] stringArray) throws Exception {
        new SSLClientAuth().doIt(stringArray);
    }

    public void doIt(String[] stringArray) throws Exception {
        int n;
        X509Certificate[] x509CertificateArray;
        if (stringArray.length < 2) {
            System.out.println("Usage: java org.mozilla.jss.tests.SSLClientAuth <dbdir> <passwordFile> [port] [bypass]");
            System.exit(1);
        }
        CryptoManager.initialize(stringArray[0]);
        this.cm = CryptoManager.getInstance();
        CryptoToken cryptoToken = this.cm.getInternalKeyStorageToken();
        FilePasswordCallback filePasswordCallback = new FilePasswordCallback(stringArray[1]);
        cryptoToken.login(filePasswordCallback);
        if (stringArray.length == 3) {
            this.port = new Integer(stringArray[2]);
            System.out.println("using port:" + this.port);
        }
        if (stringArray.length == 4 && stringArray[3].equalsIgnoreCase("bypass")) {
            SSLSocket.bypassPKCS11Default(true);
            System.out.println("enabled bypassPKCS11 mode for all sockets");
            System.out.println(SSLSocket.getSSLDefaultOptions());
        }
        SecureRandom secureRandom = SecureRandom.getInstance("pkcs11prng", "Mozilla-JSS");
        do {
            n = SSLClientAuth.nextRandInt(secureRandom);
            this.serverCertNick = "servercertnick" + n;
        } while ((x509CertificateArray = this.cm.findCertsByNickname(this.serverCertNick)).length > 0);
        int n2 = 512;
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "Mozilla-JSS");
        keyPairGenerator.initialize(n2);
        KeyPair keyPair = keyPairGenerator.genKeyPair();
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addElement(SSLClientAuth.makeBasicConstraintsExtension());
        Certificate certificate = SSLClientAuth.makeCert("CACert", "CACert", n + 1, keyPair.getPrivate(), keyPair.getPublic(), n, sEQUENCE);
        X509Certificate x509Certificate = this.cm.importUserCACertPackage(ASN1Util.encode(certificate), "cacertnick" + n);
        InternalCertificate internalCertificate = (InternalCertificate)x509Certificate;
        internalCertificate.setSSLTrust(152);
        keyPairGenerator.initialize(n2);
        KeyPair keyPair2 = keyPairGenerator.genKeyPair();
        Certificate certificate2 = SSLClientAuth.makeCert("CACert", "localhost", n + 2, keyPair.getPrivate(), keyPair2.getPublic(), n, null);
        this.serverCertNick = "servercertnick" + n;
        this.nssServerCert = this.cm.importCertPackage(ASN1Util.encode(certificate2), this.serverCertNick);
        keyPairGenerator.initialize(n2);
        KeyPair keyPair3 = keyPairGenerator.genKeyPair();
        Certificate certificate3 = SSLClientAuth.makeCert("CACert", "ClientCert", n + 3, keyPair.getPrivate(), keyPair3.getPublic(), n, null);
        this.clientCertNick = "clientcertnick" + n;
        this.nssClientCert = this.cm.importCertPackage(ASN1Util.encode(certificate3), this.clientCertNick);
        this.configureDefaultSSLoptions();
        this.useNickname = false;
        this.testConnection();
        this.useNickname = true;
        this.testConnection();
        System.out.println("Exiting main()");
        if (this.getSuccess()) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    private void configureDefaultSSLoptions() {
        try {
            SSLSocket.enableSSL2Default(false);
            SSLSocket.enableSSL3Default(false);
            if (this.cm.FIPSEnabled()) {
                System.out.println("The NSS database is confirued in FIPSmode.");
                System.out.println("Enable ony FIPS ciphersuites.");
                int[] nArray = SSLSocket.getImplementedCipherSuites();
                for (int i = 0; i < nArray.length; ++i) {
                    if (SSLSocket.isFipsCipherSuite(nArray[i])) {
                        SSLSocket.setCipherPreferenceDefault(nArray[i], true);
                        continue;
                    }
                    if (!SSLSocket.getCipherPreferenceDefault(nArray[i])) continue;
                    SSLSocket.setCipherPreferenceDefault(nArray[i], false);
                }
            }
        }
        catch (SocketException socketException) {
            System.out.println("Error configuring default SSL options.");
            socketException.printStackTrace();
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConnection() throws Exception {
        this.serverReady = false;
        Thread thread = new Thread(this);
        thread.start();
        Object object = this;
        synchronized (object) {
            while (!this.serverReady) {
                this.wait();
            }
        }
        System.out.println("client about to connect");
        object = new SSLSocket("localhost", this.port);
        if (this.useNickname) {
            ((SSLSocket)object).setClientCertNickname(this.clientCertNick);
            System.out.println("Client specified cert by nickname");
        } else {
            ((SSLSocket)object).setClientCert(this.nssClientCert);
            System.out.println("Client specified cert directly");
        }
        System.out.println("client connected");
        ((SSLSocket)object).addHandshakeCompletedListener(new HandshakeListener("client", this));
        ((SSLSocket)object).forceHandshake();
        String string = ((SSLSocket)object).getStatus().getCipher();
        System.out.println("client forced handshake. ciphersuite: " + string);
        ((SSLSocket)object).close();
        thread.join();
    }

    public synchronized void setFailure() {
        this.success = false;
    }

    public synchronized boolean getSuccess() {
        return this.success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            SSLServerSocket.configServerSessionIDCache(10, 100, 100, null);
            System.out.println("Server about to create socket");
            SSLServerSocket sSLServerSocket = new SSLServerSocket(this.port, 5, null, null, true);
            System.out.println("Server created socket");
            sSLServerSocket.requireClientAuth(21);
            if (this.useNickname) {
                sSLServerSocket.setServerCertNickname(this.serverCertNick);
                System.out.println("Server specified cert by nickname");
            } else {
                sSLServerSocket.setServerCert(this.nssServerCert);
                System.out.println("Server specified cert directly");
            }
            Object object = this;
            synchronized (object) {
                this.serverReady = true;
                this.notify();
            }
            System.out.println("Server about to accept");
            object = (SSLSocket)sSLServerSocket.accept();
            System.out.println("Server accepted");
            ((SSLSocket)object).addHandshakeCompletedListener(new HandshakeListener("server", this));
            InputStream inputStream = ((SSLSocket)object).getInputStream();
            try {
                System.out.println("Server about to read");
                inputStream.read();
                System.out.println("Server read successful");
            }
            catch (EOFException eOFException) {
                System.out.println("Server got EOF");
            }
            ((SSLSocket)object).close();
            sSLServerSocket.close();
        }
        catch (Exception exception) {
            SSLClientAuth sSLClientAuth = this;
            synchronized (sSLClientAuth) {
                this.serverReady = true;
                this.setFailure();
                this.notify();
            }
            exception.printStackTrace();
        }
        System.out.println("Server exiting");
    }

    static Extension makeBasicConstraintsExtension() throws Exception {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addElement(new BOOLEAN(true));
        OBJECT_IDENTIFIER oBJECT_IDENTIFIER = new OBJECT_IDENTIFIER(new long[]{2L, 5L, 29L, 19L});
        OCTET_STRING oCTET_STRING = new OCTET_STRING(ASN1Util.encode(sEQUENCE));
        return new Extension(oBJECT_IDENTIFIER, true, oCTET_STRING);
    }

    static int nextRandInt(SecureRandom secureRandom) throws Exception {
        byte[] byArray = new byte[4];
        secureRandom.nextBytes(byArray);
        int n = byArray[0] << 24 | byArray[1] << 16 | byArray[2] << 8 | byArray[3];
        System.out.println("generated random value:" + n);
        return n;
    }

    public static class HandshakeListener
    implements SSLHandshakeCompletedListener {
        private String who;
        private SSLClientAuth boss;

        public HandshakeListener(String string, SSLClientAuth sSLClientAuth) {
            this.who = string;
            this.boss = sSLClientAuth;
        }

        public void handshakeCompleted(SSLHandshakeCompletedEvent sSLHandshakeCompletedEvent) {
            try {
                String string = this.who + " got a completed handshake ";
                SSLSecurityStatus sSLSecurityStatus = sSLHandshakeCompletedEvent.getStatus();
                string = sSLSecurityStatus.isSecurityOn() ? string + "(security is ON)" : string + "(security is OFF)";
                System.out.println(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.boss.setFailure();
            }
        }
    }
}

