/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.pkcs11.PK11Token;
import org.mozilla.jss.util.Password;

public class PK10Gen {
    public static void main(String[] stringArray) {
        Password password = null;
        Password password2 = null;
        char[] cArray = new char[]{'f', 'o', 'o', 'b', 'a', 'r'};
        char[] cArray2 = new char[]{'n', 'e', 't', 's', 'c', 'a', 'p', 'e'};
        if (stringArray.length != 2) {
            System.err.println("Usage: java org.mozilla.jss.PK10Gen <dbdir> [rsa|dsa]");
            return;
        }
        try {
            CryptoManager cryptoManager;
            CryptoManager.initialize(stringArray[0]);
            try {
                cryptoManager = CryptoManager.getInstance();
            }
            catch (CryptoManager.NotInitializedException notInitializedException) {
                System.out.println("CryptoManager not initialized");
                return;
            }
            PK11Token pK11Token = (PK11Token)cryptoManager.getInternalKeyStorageToken();
            if (!pK11Token.isLoggedIn()) {
                System.out.println("Good, isLoggedIn correctly says we're not logged in");
            } else {
                System.out.println("ERROR: isLoggedIn incorrectly says we're logged in");
            }
            password = new Password((char[])cArray.clone());
            password2 = new Password(new char[]{'\u0000'});
            pK11Token.initPassword(password2, password);
            password.clear();
            password2.clear();
            System.out.println("initialized PIN");
            pK11Token.login(password);
            System.out.println("logged in");
            String string = pK11Token.generateCertRequest("cn=christina Fu", 512, stringArray[1], null, null, null);
            System.out.println("pkcs#10 blob = \n" + string);
        }
        catch (Exception exception) {
            System.out.println("exception caught in PK10Gen: " + exception.getMessage());
            exception.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

