/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.Vector;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.ssl.SSLHandshakeCompletedEvent;
import org.mozilla.jss.ssl.SSLHandshakeCompletedListener;
import org.mozilla.jss.ssl.SSLSecurityStatus;
import org.mozilla.jss.ssl.SSLServerSocket;
import org.mozilla.jss.ssl.SSLSocket;
import org.mozilla.jss.tests.Constants;
import org.mozilla.jss.tests.FilePasswordCallback;

public class JSS_SSLServer {
    private static Vector jssSupportedCiphers = new Vector();
    private static SSLServerSocket serverSock = null;
    private static SSLSocket sock = null;
    private String serverCertNick = null;
    private String serverHost = "localhost";
    private boolean TestInetAddress = false;
    private boolean success = true;
    private boolean bTestFipsMode = false;
    public int port = 29750;
    public static String usage = "USAGE: java JSS_SSLServer <cert db path> <passwords> <server_name> <servercertnick> [ true | false ] [ portNumber ] [ bypass ]";

    public static void main(String[] stringArray) throws Exception {
        try {
            new JSS_SSLServer().doIt(stringArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Thread.currentThread();
            Thread.sleep(3500L);
            sock.close();
            serverSock.close();
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Thread Interrupted, exiting normally ...\n");
            System.exit(0);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            System.exit(1);
        }
    }

    public void doIt(String[] stringArray) throws Exception {
        boolean bl;
        if (stringArray.length < 4) {
            System.out.println(usage);
            System.exit(1);
        }
        CryptoManager.initialize(stringArray[0]);
        CryptoManager cryptoManager = CryptoManager.getInstance();
        CryptoToken cryptoToken = cryptoManager.getInternalKeyStorageToken();
        FilePasswordCallback filePasswordCallback = new FilePasswordCallback(stringArray[1]);
        try {
            cryptoToken.login(filePasswordCallback);
        }
        catch (Exception exception) {
            System.out.println("unable to log into the token");
            exception.printStackTrace();
            System.exit(1);
        }
        this.serverHost = stringArray[2];
        this.serverCertNick = stringArray[3];
        if (stringArray.length >= 5 && stringArray[4].equalsIgnoreCase("true")) {
            this.TestInetAddress = true;
            System.out.println("testing Inet Address");
        }
        if (stringArray.length >= 6) {
            this.port = new Integer(stringArray[5]);
            System.out.println("using port: " + this.port);
        }
        if (stringArray.length >= 7 && stringArray[6].equalsIgnoreCase("bypass")) {
            SSLSocket.bypassPKCS11Default(true);
            System.out.println("enabled bypassPKCS11 mode for all sockets");
        }
        if (stringArray.length == 8 && stringArray[7].equalsIgnoreCase("fips")) {
            this.bTestFipsMode = true;
            System.out.println("testing in FIPS mode bypass must be off");
            SSLSocket.bypassPKCS11Default(false);
        }
        SSLServerSocket.configServerSessionIDCache(10, 100, 100, null);
        if (!this.bTestFipsMode) {
            for (int i = 65281; i <= 65287; ++i) {
                if (i == 65285) continue;
                SSLSocket.setCipherPreferenceDefault(i, true);
            }
        }
        int[] nArray = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 27, 28, 29, 30, 34, 40};
        int[] nArray2 = new int[]{27, 28, 34, 40};
        int[] nArray3 = !this.bTestFipsMode ? nArray : nArray2;
        System.out.println("JSSServerCipher length" + nArray3.length);
        for (bl = false; bl < nArray3.length; bl += 1) {
            try {
                SSLSocket.setCipherPreferenceDefault(Constants.jssCipherSuites[nArray3[bl]], true);
                if (Constants.debug_level < 3) continue;
                System.out.println("Added Cipher" + (int)(bl ? 1 : 0) + Constants.jssCipherNames[nArray3[bl]]);
                continue;
            }
            catch (Exception exception) {
                if (Constants.debug_level < 3) continue;
                System.out.println("Added Cipher" + (int)(bl ? 1 : 0) + Constants.jssCipherNames[nArray3[bl]]);
            }
        }
        if (Constants.debug_level >= 3) {
            System.out.println("Server about .... to create socket");
        }
        if (this.TestInetAddress) {
            if (Constants.debug_level >= 3) {
                System.out.println("the HostName " + this.serverHost + " the Inet Address " + InetAddress.getByName(this.serverHost));
            }
            serverSock = new SSLServerSocket(this.port, 5, InetAddress.getByName(this.serverHost), null, true);
        } else {
            if (Constants.debug_level >= 3) {
                System.out.println("Inet set to Null");
            }
            serverSock = new SSLServerSocket(this.port, 5, null, null, true);
        }
        if (Constants.debug_level >= 3) {
            System.out.println("Server created socket");
        }
        serverSock.setSoTimeout(120000);
        serverSock.requireClientAuth(21);
        serverSock.setServerCertNickname(this.serverCertNick);
        if (Constants.debug_level >= 3) {
            System.out.println("Server specified cert by nickname");
        }
        bl = true;
        while (bl) {
            try {
                sock = (SSLSocket)serverSock.accept();
            }
            catch (IOException iOException) {
                bl = false;
                System.out.println("Timeout occurred on the serversocket");
                break;
            }
            if (Constants.debug_level >= 3) {
                System.out.println("accepted " + bl);
            }
            sock.addHandshakeCompletedListener(new HandshakeListener("server", this));
            InputStream inputStream = sock.getInputStream();
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String string = bufferedReader.readLine();
                if (string.equals("null")) {
                    bl = false;
                    if (Constants.debug_level >= 3) {
                        System.out.println("breaking cipher loop");
                    }
                } else if (string != null) {
                    jssSupportedCiphers.add(string);
                    if (Constants.debug_level >= 3) {
                        System.out.println("accepted using " + string);
                    }
                }
            }
            catch (EOFException eOFException) {
            }
            catch (IOException iOException) {
            }
            catch (NullPointerException nullPointerException) {
                bl = false;
            }
            sock.close();
        }
        serverSock.close();
        System.out.println("Server exiting");
        System.out.println("---------------------------------------------------------");
        System.out.println("Summary of JSSE client to JSS server communication test :");
        System.out.println("---------------------------------------------------------");
        for (int i = 0; i < jssSupportedCiphers.size(); ++i) {
            System.out.println("[" + i + "]\t" + jssSupportedCiphers.elementAt(i));
        }
        System.out.println("---------------------------------------------------------");
        System.out.println("Please note that in JDK 5.0 the same set of ");
        System.out.println("ciphers are exercised for SSLv3 and TLS.");
        System.out.println("---------------------------------------------------------");
        System.out.flush();
        if (this.getSuccess()) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    public synchronized void setFailure() {
        this.success = false;
    }

    public synchronized boolean getSuccess() {
        return this.success;
    }

    public static class HandshakeListener
    implements SSLHandshakeCompletedListener {
        private String who;
        private JSS_SSLServer boss;

        public HandshakeListener(String string, JSS_SSLServer jSS_SSLServer) {
            this.who = string;
            this.boss = jSS_SSLServer;
        }

        public void handshakeCompleted(SSLHandshakeCompletedEvent sSLHandshakeCompletedEvent) {
            try {
                String string = this.who + " got a completed handshake ";
                SSLSecurityStatus sSLSecurityStatus = sSLHandshakeCompletedEvent.getStatus();
                string = sSLSecurityStatus.isSecurityOn() ? string + "(security is ON)" : string + "(security is OFF)";
                if (Constants.debug_level >= 3) {
                    System.out.println(string);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.boss.setFailure();
            }
        }
    }
}

