/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.io.FileInputStream;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.SecretKeyFacade;
import org.mozilla.jss.util.Debug;

public class HMACTest {
    public static void doHMAC(SecretKeyFacade secretKeyFacade, String string) throws Exception {
        String string2 = new String("Hi There");
        Mac mac = Mac.getInstance(string, "Mozilla-JSS");
        mac.init(secretKeyFacade);
        mac.update(string2.getBytes());
        byte[] byArray = mac.doFinal(string2.getBytes());
        Mac mac2 = null;
        String string3 = System.getProperty("java.vendor");
        mac2 = string3.equals("IBM Corporation") ? Mac.getInstance(string, "IBMJCE") : Mac.getInstance(string, "SunJCE");
        mac2.init(secretKeyFacade);
        mac2.update(string2.getBytes());
        byte[] byArray2 = mac2.doFinal(string2.getBytes());
        if (!Arrays.equals(byArray, byArray2)) {
            throw new Exception("ERROR: " + string3 + " JCE and Mozilla-JSS give different " + string);
        }
        System.out.println(string3 + " JCE and Mozilla-JSS give same " + string);
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length != 2) {
                System.out.println("Usage: java org.mozilla.jss.tests.HMACTest <dbdir> <passwordFile>");
                System.exit(1);
            }
            String string = stringArray[0];
            FileInputStream fileInputStream = new FileInputStream(stringArray[1]);
            byte[] byArray = new byte[fileInputStream.available()];
            int n = fileInputStream.read(byArray);
            System.out.println(n + " bytes to be digested");
            CryptoManager.initialize(string);
            Debug.setLevel(1);
            Provider[] providerArray = Security.getProviders();
            for (int i = 0; i < providerArray.length; ++i) {
                System.out.println("Provider " + i + ": " + providerArray[i].getName());
            }
            byte[] byArray2 = new byte[]{10, 109, 7, -70, 30, -67, 114, -15};
            int n2 = 7;
            PBEKeySpec pBEKeySpec = new PBEKeySpec("password".toCharArray(), byArray2, n2);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBEWithSHA1AndDESede", "Mozilla-JSS");
            SecretKeyFacade secretKeyFacade = (SecretKeyFacade)secretKeyFactory.generateSecret(pBEKeySpec);
            HMACTest.doHMAC(secretKeyFacade, "HmacSHA1");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

