/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.math.BigInteger;
import java.util.Enumeration;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.DatabaseCloser;
import org.mozilla.jss.crypto.CryptoStore;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.X509Certificate;

public final class CloseDBs
extends DatabaseCloser {
    public static void main(String[] stringArray) {
        try {
            if (stringArray.length != 1) {
                System.err.println("Usage: CloseDBs <dbdir>");
                System.exit(0);
            }
            CryptoManager.initialize(stringArray[0]);
            CryptoManager cryptoManager = CryptoManager.getInstance();
            Enumeration enumeration = cryptoManager.getAllTokens();
            while (enumeration.hasMoreElements()) {
                int n;
                CryptoToken cryptoToken = (CryptoToken)enumeration.nextElement();
                CryptoStore cryptoStore = cryptoToken.getCryptoStore();
                System.out.println("Token: " + cryptoToken.getName());
                X509Certificate[] x509CertificateArray = cryptoStore.getCertificates();
                System.out.println("Certs:");
                for (n = 0; n < x509CertificateArray.length; ++n) {
                    System.out.println(x509CertificateArray[n].getNickname());
                }
                PrivateKey[] privateKeyArray = cryptoStore.getPrivateKeys();
                System.out.println("Keys:");
                try {
                    for (n = 0; n < privateKeyArray.length; ++n) {
                        System.out.println(new BigInteger(privateKeyArray[n].getEncoded()));
                    }
                }
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                }
            }
            System.out.println("Closing databases...");
            try {
                new CloseDBs().closeDatabases();
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                System.exit(1);
            }
            System.out.println("Databases are closed.");
            System.exit(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

