/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.primitive;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.Attribute;

public class PrivateKeyInfo
implements ASN1Value,
PrivateKey {
    private INTEGER version;
    private AlgorithmIdentifier privateKeyAlgorithm;
    private OCTET_STRING privateKey;
    private SET attributes;
    private SEQUENCE sequence;
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public INTEGER getVersion() {
        return this.version;
    }

    public AlgorithmIdentifier getPrivateKeyAlgorithm() {
        return this.privateKeyAlgorithm;
    }

    public String getAlgorithm() {
        try {
            return PrivateKey.Type.fromOID(this.privateKeyAlgorithm.getOID()).toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public byte[] getEncoded() {
        return this.privateKey.toByteArray();
    }

    public OCTET_STRING getPrivateKey() {
        return this.privateKey;
    }

    public SET getAttributes() {
        return this.attributes;
    }

    private PrivateKeyInfo() {
    }

    public PrivateKeyInfo(INTEGER iNTEGER, AlgorithmIdentifier algorithmIdentifier, OCTET_STRING oCTET_STRING, SET sET) {
        if (iNTEGER == null || algorithmIdentifier == null || oCTET_STRING == null) {
            throw new IllegalArgumentException("PrivateKeyInfo parameter is null");
        }
        this.version = iNTEGER;
        this.privateKeyAlgorithm = algorithmIdentifier;
        this.privateKey = oCTET_STRING;
        this.attributes = sET;
        this.sequence = new SEQUENCE();
        this.sequence.addElement(iNTEGER);
        this.sequence.addElement(algorithmIdentifier);
        this.sequence.addElement(oCTET_STRING);
        if (sET != null) {
            this.sequence.addElement(new Tag(0L), sET);
            int n = sET.size();
            for (int i = 0; i < n; ++i) {
                if (sET.elementAt(i) instanceof Attribute) continue;
                throw new IllegalArgumentException("element " + i + " of attributes is not an Attribute");
            }
        }
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.sequence.encode(outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        this.sequence.encode(tag, outputStream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addElement(AlgorithmIdentifier.getTemplate());
            this.seqt.addElement(OCTET_STRING.getTemplate());
            this.seqt.addOptionalElement(new Tag(0L), new SET.OF_Template(Attribute.getTemplate()));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws InvalidBERException, IOException {
            SEQUENCE sEQUENCE = (SEQUENCE)this.seqt.decode(tag, inputStream);
            return new PrivateKeyInfo((INTEGER)sEQUENCE.elementAt(0), (AlgorithmIdentifier)sEQUENCE.elementAt(1), (OCTET_STRING)sEQUENCE.elementAt(2), (SET)sEQUENCE.elementAt(3));
        }
    }
}

