/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.primitive;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.NULL;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.util.Assert;

public class AlgorithmIdentifier
implements ASN1Value {
    private OBJECT_IDENTIFIER oid;
    private ASN1Value parameters = null;
    private SEQUENCE sequence = new SEQUENCE();
    public static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public Tag getTag() {
        return TAG;
    }

    public AlgorithmIdentifier(OBJECT_IDENTIFIER oBJECT_IDENTIFIER) {
        this.oid = oBJECT_IDENTIFIER;
        this.sequence.addElement(oBJECT_IDENTIFIER);
    }

    public AlgorithmIdentifier(OBJECT_IDENTIFIER oBJECT_IDENTIFIER, ASN1Value aSN1Value) {
        this.oid = oBJECT_IDENTIFIER;
        this.sequence.addElement(oBJECT_IDENTIFIER);
        this.parameters = aSN1Value;
        if (aSN1Value != null) {
            this.sequence.addElement(aSN1Value);
        } else {
            this.sequence.addElement(new NULL());
        }
    }

    public OBJECT_IDENTIFIER getOID() {
        return this.oid;
    }

    public ASN1Value getParameters() {
        return this.parameters;
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(TAG, outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        this.sequence.encode(tag, outputStream);
    }

    public static class Template
    implements ASN1Template {
        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws IOException, InvalidBERException {
            SEQUENCE.Template template = new SEQUENCE.Template();
            template.addElement(new OBJECT_IDENTIFIER.Template());
            template.addOptionalElement(new ANY.Template());
            SEQUENCE sEQUENCE = (SEQUENCE)template.decode(tag, inputStream);
            Assert._assert(sEQUENCE.size() == 2);
            return new AlgorithmIdentifier((OBJECT_IDENTIFIER)sEQUENCE.elementAt(0), sEQUENCE.elementAt(1));
        }
    }
}

