/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.crmf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BOOLEAN;
import org.mozilla.jss.asn1.CHOICE;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.crmf.EncryptedKey;
import org.mozilla.jss.util.Assert;

public class PKIArchiveOptions
implements ASN1Value {
    public static final Type ENCRYPTED_PRIV_KEY = Type.ENCRYPTED_PRIV_KEY;
    public static final Type KEY_GEN_PARAMETERS = Type.KEY_GEN_PARAMETERS;
    public static final Type ARCHIVE_REM_GEN_PRIV_KEY = Type.ARCHIVE_REM_GEN_PRIV_KEY;
    private EncryptedKey encryptedPrivKey;
    private OCTET_STRING keyGenParameters;
    private boolean archiveRemGenPrivKey;
    private Type type;
    private Tag tag;
    private static final Template templateInstance = new Template();

    public Type getType() {
        return this.type;
    }

    public EncryptedKey getEncryptedKey() {
        Assert._assert(this.type == ENCRYPTED_PRIV_KEY);
        return this.encryptedPrivKey;
    }

    public boolean getArchiveRemGenPrivKey() {
        Assert._assert(this.type == ARCHIVE_REM_GEN_PRIV_KEY);
        return this.archiveRemGenPrivKey;
    }

    private PKIArchiveOptions() {
    }

    public PKIArchiveOptions(EncryptedKey encryptedKey) {
        this.encryptedPrivKey = encryptedKey;
        this.type = ENCRYPTED_PRIV_KEY;
        this.tag = new Tag(0L);
    }

    public PKIArchiveOptions(byte[] byArray) {
        this.keyGenParameters = new OCTET_STRING(byArray);
        this.type = KEY_GEN_PARAMETERS;
        this.tag = new Tag(1L);
    }

    public PKIArchiveOptions(boolean bl) {
        this.archiveRemGenPrivKey = bl;
        this.type = ARCHIVE_REM_GEN_PRIV_KEY;
        this.tag = new Tag(2L);
    }

    public Tag getTag() {
        return this.tag;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(this.getTag(), outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        Assert._assert(tag.equals(this.tag));
        if (this.type == ENCRYPTED_PRIV_KEY) {
            EXPLICIT eXPLICIT = new EXPLICIT(new Tag(0L), this.encryptedPrivKey);
            eXPLICIT.encode(this.tag, outputStream);
        } else if (this.type == KEY_GEN_PARAMETERS) {
            this.keyGenParameters.encode(this.tag, outputStream);
        } else {
            Assert._assert(this.type == ARCHIVE_REM_GEN_PRIV_KEY);
            new BOOLEAN(this.archiveRemGenPrivKey).encode(this.tag, outputStream);
        }
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        CHOICE.Template template = new CHOICE.Template();

        public Template() {
            this.template.addElement(new EXPLICIT.Template(new Tag(0L), new EncryptedKey.Template()));
            this.template.addElement(new Tag(1L), new OCTET_STRING.Template());
            this.template.addElement(new Tag(2L), new BOOLEAN.Template());
        }

        public boolean tagMatch(Tag tag) {
            return this.template.tagMatch(tag);
        }

        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            CHOICE cHOICE = (CHOICE)this.template.decode(inputStream);
            if (cHOICE.getTag().getNum() == 0L) {
                EncryptedKey encryptedKey = (EncryptedKey)((EXPLICIT)cHOICE.getValue()).getContent();
                return new PKIArchiveOptions(encryptedKey);
            }
            if (cHOICE.getTag().getNum() == 1L) {
                OCTET_STRING oCTET_STRING = (OCTET_STRING)cHOICE.getValue();
                return new PKIArchiveOptions(oCTET_STRING.toByteArray());
            }
            if (cHOICE.getTag().getNum() == 2L) {
                BOOLEAN bOOLEAN = (BOOLEAN)cHOICE.getValue();
                return new PKIArchiveOptions(bOOLEAN.toBoolean());
            }
            String string = "Unrecognized tag in PKIArchiveOptions";
            Assert.notReached(string);
            throw new InvalidBERException(string);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(inputStream);
        }
    }

    public static class Type {
        static final Type ENCRYPTED_PRIV_KEY = new Type();
        static final Type KEY_GEN_PARAMETERS = new Type();
        static final Type ARCHIVE_REM_GEN_PRIV_KEY = new Type();

        private Type() {
        }
    }
}

