/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.crmf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;

public class EncryptedValue
implements ASN1Value {
    private AlgorithmIdentifier intendedAlg;
    private AlgorithmIdentifier symmAlg;
    private BIT_STRING encSymmKey;
    private AlgorithmIdentifier keyAlg;
    private OCTET_STRING valueHint;
    private BIT_STRING encValue;
    private SEQUENCE sequence;
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public AlgorithmIdentifier getIntendedAlg() {
        return this.intendedAlg;
    }

    public AlgorithmIdentifier getSymmAlg() {
        return this.symmAlg;
    }

    public BIT_STRING getEncSymmKey() {
        return this.encSymmKey;
    }

    public AlgorithmIdentifier getKeyAlg() {
        return this.keyAlg;
    }

    public OCTET_STRING getValueHint() {
        return this.valueHint;
    }

    public BIT_STRING getEncValue() {
        return this.encValue;
    }

    private EncryptedValue() {
    }

    public EncryptedValue(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, BIT_STRING bIT_STRING, AlgorithmIdentifier algorithmIdentifier3, OCTET_STRING oCTET_STRING, BIT_STRING bIT_STRING2) {
        if (bIT_STRING2 == null) {
            throw new IllegalArgumentException("encValue is null");
        }
        this.intendedAlg = algorithmIdentifier;
        this.symmAlg = algorithmIdentifier2;
        this.encSymmKey = bIT_STRING;
        this.keyAlg = algorithmIdentifier3;
        this.valueHint = oCTET_STRING;
        this.encValue = bIT_STRING2;
        this.sequence = new SEQUENCE();
        if (algorithmIdentifier != null) {
            this.sequence.addElement(new Tag(0L), algorithmIdentifier);
        }
        if (algorithmIdentifier2 != null) {
            this.sequence.addElement(new Tag(1L), algorithmIdentifier2);
        }
        if (bIT_STRING != null) {
            this.sequence.addElement(new Tag(2L), bIT_STRING);
        }
        if (algorithmIdentifier3 != null) {
            this.sequence.addElement(new Tag(3L), algorithmIdentifier3);
        }
        if (oCTET_STRING != null) {
            this.sequence.addElement(new Tag(4L), oCTET_STRING);
        }
        this.sequence.addElement(bIT_STRING2);
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.sequence.encode(outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        this.sequence.encode(tag, outputStream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addOptionalElement(new Tag(0L), AlgorithmIdentifier.getTemplate());
            this.seqt.addOptionalElement(new Tag(1L), AlgorithmIdentifier.getTemplate());
            this.seqt.addOptionalElement(new Tag(2L), BIT_STRING.getTemplate());
            this.seqt.addOptionalElement(new Tag(3L), AlgorithmIdentifier.getTemplate());
            this.seqt.addOptionalElement(new Tag(4L), OCTET_STRING.getTemplate());
            this.seqt.addElement(BIT_STRING.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws InvalidBERException, IOException {
            try {
                SEQUENCE sEQUENCE = (SEQUENCE)this.seqt.decode(tag, inputStream);
                return new EncryptedValue((AlgorithmIdentifier)sEQUENCE.elementAt(0), (AlgorithmIdentifier)sEQUENCE.elementAt(1), (BIT_STRING)sEQUENCE.elementAt(2), (AlgorithmIdentifier)sEQUENCE.elementAt(3), (OCTET_STRING)sEQUENCE.elementAt(4), (BIT_STRING)sEQUENCE.elementAt(5));
            }
            catch (InvalidBERException invalidBERException) {
                throw new InvalidBERException(invalidBERException, "EncryptedValue");
            }
        }
    }
}

