/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.PkProxyProvider;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.objects.PrivateKey;
import iaik.pkcs.pkcs11.objects.RSAPrivateKey;
import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;

public class PK11Signature
extends SignatureSpi {
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private PrivateKey privateKey = null;
    private Session sess = null;

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        throw new InvalidParameterException("Not implemented yet");
    }

    protected void engineInitSign(java.security.PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof PkProxyProvider)) {
            throw new InvalidKeyException("La clave privada indicada no es compatible");
        }
        this.privateKey = ((PkProxyProvider)privateKey).getPrivateKey();
        this.sess = ((PkProxyProvider)privateKey).getSession();
    }

    protected void engineUpdate(byte b) throws SignatureException {
        this.baos.write(b);
    }

    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.baos.write(b, off, len);
    }

    protected byte[] engineSign() throws SignatureException {
        if (this.baos.size() <= 0) {
            throw new SignatureException("No hay datos de entrada a firmar");
        }
        if (this.sess == null || this.privateKey == null) {
            throw new SignatureException("No se pudo recuperar la clave privada de la sesi\u00f3n");
        }
        try {
            byte[] toBeSigned = this.baos.toByteArray();
            this.sess.signInit(Mechanism.SHA1_RSA_PKCS, (RSAPrivateKey)this.privateKey);
            byte[] signatureValue = this.sess.sign(toBeSigned);
            return signatureValue;
        }
        catch (Throwable t) {
            throw new SignatureException(t);
        }
    }

    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        throw new InvalidParameterException("Not implemented yet");
    }

    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new InvalidParameterException("Not implemented yet");
    }

    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new InvalidParameterException("Not implemented yet");
    }
}

