/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.xml.xades.policy;

import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.xml.xades.policy.GeneralPolicyManager;
import es.mityc.javasign.xml.xades.policy.IFirmaPolicy;
import es.mityc.javasign.xml.xades.policy.IValidacionPolicy;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PoliciesManager {
    private static final Log logger = LogFactory.getLog(PoliciesManager.class);
    private static final II18nManager i18n = I18nFactory.getI18nManager((String)"MITyCLibXAdES");
    private static PoliciesManager instance = PoliciesManager.getInstance();
    private Properties props = null;
    private static final String POLICY_FILE_CONF = "META-INF/xades/policy.properties";

    public PolicyKey newPolicyKey(URI uri, String hash) {
        return new PolicyKey(uri, hash);
    }

    private PoliciesManager() {
        this.loadManagers();
    }

    private void loadManagers() {
        ClassLoader cl = PoliciesManager.getClassLoader();
        try {
            ArrayList<URL> resources = new ArrayList<URL>();
            Enumeration<URL> en = cl.getResources(POLICY_FILE_CONF);
            if (en == null || !en.hasMoreElements()) {
                logger.error((Object)"No se pudo encontrar el fichero de configuraci\u00f3n META-INF/xades/policy.properties");
            }
            URL element = null;
            while (en.hasMoreElements()) {
                element = en.nextElement();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Configuraci\u00f3n de pol\u00edtica encontrado: " + element));
                }
                resources.add(0, element);
            }
            Properties base = null;
            for (URL url : resources) {
                try {
                    InputStream is = url.openStream();
                    Properties properties = new Properties(base);
                    properties.load(is);
                    base = properties;
                }
                catch (IOException ex) {
                    logger.error((Object)i18n.getLocalMessage("i18n.mityc.xades.policy.2", new Object[]{url, ex.getMessage()}));
                }
            }
            this.props = base;
        }
        catch (IOException ex) {
            logger.error((Object)i18n.getLocalMessage("i18n.mityc.xades.policy.1", new Object[]{ex.getMessage()}));
        }
    }

    private static ClassLoader getClassLoader() {
        try {
            ClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    ClassLoader classLoader = null;
                    try {
                        classLoader = Thread.currentThread().getContextClassLoader();
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    return classLoader;
                }
            });
            if (cl != null) {
                return cl;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return PoliciesManager.class.getClassLoader();
    }

    public static PoliciesManager getInstance() {
        if (instance == null) {
            instance = new PoliciesManager();
        }
        return instance;
    }

    public IValidacionPolicy getValidadorPolicy(PolicyKey clave) {
        return this.getValidadorPolicy(clave, true);
    }

    public IValidacionPolicy getValidadorPolicy(PolicyKey clave, boolean defaultManager) {
        IValidacionPolicy policyManager = null;
        if (this.props != null) {
            block14: {
                try {
                    block15: {
                        String classname = this.props.getProperty(clave.hash);
                        if (classname == null) break block14;
                        try {
                            ClassLoader cl = PoliciesManager.getClassLoader();
                            Class<?> manager = null;
                            manager = cl != null ? cl.loadClass(classname) : Class.forName(classname);
                            if (manager != null) {
                                policyManager = (IValidacionPolicy)manager.newInstance();
                            }
                        }
                        catch (InstantiationException e) {
                            logger.warn((Object)("La clase asociada no se puede instanciar (" + clave.hash + ", " + classname + ")"));
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)"", (Throwable)e);
                            }
                        }
                        catch (IllegalAccessException e) {
                            logger.warn((Object)("No hay permisos para instanciar el validador (" + clave.hash + ", " + classname + ")"));
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)"", (Throwable)e);
                            }
                        }
                        catch (ClassNotFoundException e) {
                            logger.warn((Object)("La clase asociada al valor no se encuentra disponible (" + clave.hash + ", " + classname + ")"));
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)"", (Throwable)e);
                            }
                        }
                        catch (ClassCastException e) {
                            logger.warn((Object)("La clase asociada no es del tipo validador (" + clave.hash + " " + classname + ")"));
                            if (!logger.isDebugEnabled()) break block15;
                            logger.debug((Object)"", (Throwable)e);
                        }
                    }
                    if (policyManager == null) {
                        policyManager = new GeneralPolicyManager();
                    }
                }
                catch (MissingResourceException ex) {
                    logger.error((Object)("No hay validador de policy asociado a esa clave: " + clave));
                }
            }
            if (policyManager == null) {
                policyManager = new GeneralPolicyManager();
            }
        }
        return policyManager;
    }

    public IFirmaPolicy getEscritorPolicy(String clave) {
        IFirmaPolicy policyManager;
        block13: {
            policyManager = null;
            if (this.props != null) {
                try {
                    String classname = this.props.getProperty(clave.toLowerCase());
                    if (classname == null) break block13;
                    try {
                        ClassLoader cl = PoliciesManager.getClassLoader();
                        Class<?> manager = null;
                        manager = cl != null ? cl.loadClass(classname) : Class.forName(classname);
                        if (manager != null) {
                            policyManager = (IFirmaPolicy)manager.newInstance();
                        }
                    }
                    catch (InstantiationException e) {
                        logger.warn((Object)("La clase asociada no se puede instanciar (" + clave + ", " + classname + ")"));
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"", (Throwable)e);
                        }
                    }
                    catch (IllegalAccessException e) {
                        logger.warn((Object)("No hay permisos para instanciar el validador (" + clave + ", " + classname + ")"));
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"", (Throwable)e);
                        }
                    }
                    catch (ClassNotFoundException e) {
                        logger.warn((Object)("La clase asociada al valor no se encuentra disponible (" + clave + ", " + classname + ")"));
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"", (Throwable)e);
                        }
                    }
                    catch (ClassCastException e) {
                        logger.warn((Object)("La clase asociada no es del tipo validador (" + clave + " " + classname + ")"));
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"", (Throwable)e);
                        }
                    }
                }
                catch (MissingResourceException ex) {
                    logger.error((Object)("No hay validador de policy asociado a esa clave: " + clave));
                }
            }
        }
        return policyManager;
    }

    public class PolicyKey {
        public URI uri;
        public String hash;

        public PolicyKey(URI uri, String hash) {
            this.uri = uri;
            this.hash = hash;
        }
    }
}

