/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.xml.xades;

import es.mityc.firmaJava.libreria.utilidades.UtilidadFicheros;
import es.mityc.javasign.certificate.AbstractCertStatus;
import es.mityc.javasign.certificate.ElementNotFoundException;
import es.mityc.javasign.certificate.ICertStatus;
import es.mityc.javasign.certificate.IOCSPCertStatus;
import es.mityc.javasign.certificate.IRecoverElements;
import es.mityc.javasign.certificate.IX509CRLCertStatus;
import es.mityc.javasign.certificate.OCSPResponderID;
import es.mityc.javasign.certificate.UnknownElementClassException;
import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.xml.xades.IStoreElements;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Map;
import java.util.zip.Adler32;
import java.util.zip.Checksum;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalFileStoreElements
implements IStoreElements,
IRecoverElements {
    private static Log log = LogFactory.getLog(LocalFileStoreElements.class);
    private static II18nManager i18n = I18nFactory.getI18nManager((String)"MITyCLibXAdES");
    private static final String PREFIX_CERT = "cert-";
    private static final String EXT_CERT = ".cer";
    private static final String PREFIX_OCSP = "ocsp-";
    private static final String EXT_OCSP = ".ors";
    private static final String PREFIX_CRL = "crl-";
    private static final String EXT_CRL = ".crl";
    private URI base = null;
    private static ThreadLocal<Adler32> digester = new ThreadLocal<Adler32>(){

        @Override
        protected Adler32 initialValue() {
            return new Adler32();
        }
    };

    public LocalFileStoreElements() {
        this.init(null);
    }

    public LocalFileStoreElements(String base) {
        this.init(base);
    }

    private URI getWorkdir() {
        return new File(".").toURI();
    }

    @Override
    public void init(String base) {
        if (base == null || base.trim().length() == 0) {
            this.base = this.getWorkdir();
        } else {
            try {
                this.base = URI.create(base);
            }
            catch (IllegalArgumentException ex) {
                log.error((Object)i18n.getLocalMessage("i18n.mityc.xades.sign.5", new Object[]{ex.getMessage()}));
                this.base = this.getWorkdir();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveData(File file, byte[] data) {
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(file);
                fos.write(data);
                return;
            }
            catch (FileNotFoundException ex) {
                log.error((Object)i18n.getLocalMessage("i18n.mityc.xades.sign.6", new Object[]{ex.getMessage(), file.getAbsolutePath()}));
                if (fos == null) return;
                try {
                    fos.flush();
                    fos.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
            catch (IOException ex) {
                log.error((Object)i18n.getLocalMessage("i18n.mityc.xades.sign.6", new Object[]{ex.getMessage(), file.getAbsolutePath()}));
                if (fos == null) return;
                try {
                    fos.flush();
                    fos.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
        }
        finally {
            if (fos != null) {
                try {
                    fos.flush();
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private long digest(byte[] data) {
        Checksum digest = digester.get();
        digest.reset();
        digest.update(data, 0, data.length);
        return digest.getValue();
    }

    @Override
    public String[] storeCertAndStatus(X509Certificate certificate, ICertStatus certStatus) {
        String[] names = new String[2];
        File dir = new File(this.base);
        if (!dir.exists() && !dir.mkdirs()) {
            return names;
        }
        if (certificate != null) {
            try {
                byte[] data = certificate.getEncoded();
                String nameCert = PREFIX_CERT + Long.toHexString(this.digest(data)) + EXT_CERT;
                File certFile = new File(dir, nameCert);
                this.saveData(certFile, data);
                names[0] = certFile.getName();
            }
            catch (CertificateEncodingException ex) {
                log.error((Object)i18n.getLocalMessage("i18n.mityc.xades.sign.6", new Object[]{ex.getMessage()}));
            }
        }
        if (certStatus != null) {
            byte[] data;
            if (certStatus instanceof IOCSPCertStatus) {
                IOCSPCertStatus respOcsp = (IOCSPCertStatus)certStatus;
                data = respOcsp.getEncoded();
                String ocspName = PREFIX_OCSP + Long.toHexString(this.digest(data)) + EXT_OCSP;
                File ocspFile = new File(dir, ocspName);
                this.saveData(ocspFile, data);
                names[1] = ocspFile.getName();
            } else if (certStatus instanceof IX509CRLCertStatus) {
                IX509CRLCertStatus respCRL = (IX509CRLCertStatus)certStatus;
                data = respCRL.getEncoded();
                String crlName = PREFIX_CRL + Long.toHexString(this.digest(data)) + EXT_CRL;
                File crlFile = new File(dir, crlName);
                this.saveData(crlFile, data);
                names[1] = crlFile.getName();
            }
        }
        return names;
    }

    public <T> T getElement(Map<String, Object> props, Class<T> elementClass) throws ElementNotFoundException, UnknownElementClassException {
        if (X509Certificate.class.isAssignableFrom(elementClass)) {
            X509Certificate cert = this.getCertificate(props);
            if (cert != null) {
                return (T)cert;
            }
            throw new ElementNotFoundException();
        }
        if (IOCSPCertStatus.class.isAssignableFrom(elementClass)) {
            IOCSPCertStatus ocsp = this.getOCSPResponse(props);
            if (ocsp != null) {
                return (T)ocsp;
            }
            throw new ElementNotFoundException();
        }
        if (X509CRL.class.isAssignableFrom(elementClass)) {
            X509CRL crl = this.getCRL(props);
            if (crl != null) {
                return (T)crl;
            }
            throw new ElementNotFoundException();
        }
        throw new UnknownElementClassException();
    }

    private X509CRL getCRL(Map<String, Object> props) {
        Object uriObj;
        if (props != null && (uriObj = props.get("uri")) != null && uriObj instanceof String) {
            return this.getCRL((String)uriObj);
        }
        return null;
    }

    private X509CRL getCRL(String uri) {
        X509CRL crl;
        block18: {
            crl = null;
            File dir = new File(this.base);
            try {
                FileInputStream fis = new FileInputStream(new File(dir, uri));
                try {
                    try {
                        CertificateFactory cf = CertificateFactory.getInstance("X.509");
                        crl = (X509CRL)cf.generateCRL(fis);
                    }
                    catch (CertificateException certificateException) {
                        if (fis == null) break block18;
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {
                        }
                    }
                    catch (CRLException cRLException) {
                        if (fis == null) break block18;
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return crl;
    }

    private IOCSPCertStatus getOCSPResponse(Map<String, Object> props) {
        if (props != null) {
            Object uriObj = props.get("uri");
            if (uriObj != null && uriObj instanceof String) {
                return this.getOCSPResponse((String)uriObj);
            }
            Object emissiondateObj = props.get("emission.date");
            Object digestalgObj = props.get("digest.algorithm");
            Object digestvalueObj = props.get("digest.value");
            Object issuernameObj = props.get("issuer.name");
            Object issuerhashObj = props.get("issuer.hash");
            if (digestalgObj != null && digestalgObj instanceof String && digestvalueObj != null && digestvalueObj instanceof byte[] && emissiondateObj != null && emissiondateObj instanceof Date && (issuernameObj != null && issuernameObj instanceof X500Principal || issuerhashObj != null && issuerhashObj instanceof byte[])) {
                OCSPResponderID issuer = null;
                if (issuernameObj != null) {
                    issuer = OCSPResponderID.getOCSPResponderID((X500Principal)((X500Principal)issuernameObj));
                } else if (issuerhashObj != null) {
                    issuer = OCSPResponderID.getOCSPResponderID((byte[])((byte[])issuerhashObj));
                }
                return this.getOCSPResponse((String)digestalgObj, (byte[])digestvalueObj, issuer, (Date)emissiondateObj);
            }
        }
        return null;
    }

    private IOCSPCertStatus getOCSPResponse(String uri) {
        byte[] data;
        OCSPResp ocsp = null;
        File file = new File(new File(this.base), uri);
        if (file.exists() && (data = UtilidadFicheros.readFile(file)) != null) {
            ocsp = new OCSPResp(data);
        }
        return ocsp;
    }

    private IOCSPCertStatus getOCSPResponse(String digestAlg, byte[] digestValue, OCSPResponderID issuer, Date emission) {
        IOCSPCertStatus ocsp = null;
        return ocsp;
    }

    private X509Certificate getCertificate(Map<String, Object> props) {
        if (props != null) {
            Object uriObj = props.get("uri");
            if (uriObj != null && uriObj instanceof String) {
                return this.getCertificate((String)uriObj);
            }
            Object issuernameObj = props.get("issuer.name");
            Object serialnumberObj = props.get("serial.number");
            if (issuernameObj != null && issuernameObj instanceof X500Principal && serialnumberObj != null && serialnumberObj instanceof BigInteger) {
                return this.getCertificate((X500Principal)issuernameObj, (BigInteger)serialnumberObj);
            }
        }
        return null;
    }

    private X509Certificate getCertificate(String uri) {
        X509Certificate certificate;
        block14: {
            certificate = null;
            File dir = new File(this.base);
            try {
                FileInputStream fis = new FileInputStream(new File(dir, uri));
                try {
                    try {
                        CertificateFactory cf = CertificateFactory.getInstance("X.509");
                        certificate = (X509Certificate)cf.generateCertificate(fis);
                    }
                    catch (CertificateException certificateException) {
                        if (fis == null) break block14;
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return certificate;
    }

    private X509Certificate getCertificate(X500Principal issuername, BigInteger serialnumber) {
        X509Certificate certificate = null;
        return certificate;
    }

    private class OCSPResp
    extends AbstractCertStatus
    implements IOCSPCertStatus {
        private byte[] data;

        private OCSPResp(byte[] data) {
            this.data = data;
        }

        public byte[] getEncoded() {
            return this.data;
        }

        public String getResponderID() {
            throw new UnsupportedOperationException("Not implemented yet");
        }

        public IOCSPCertStatus.TYPE_RESPONDER getResponderType() {
            throw new UnsupportedOperationException("Not implemented yet");
        }

        public Date getResponseDate() {
            throw new UnsupportedOperationException("Not implemented yet");
        }
    }
}

