/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.libreria.xades.elementos.xmldsig;

import es.mityc.firmaJava.libreria.xades.elementos.xmldsig.AbstractXDsigElement;
import es.mityc.firmaJava.libreria.xades.elementos.xmldsig.X509IssuerName;
import es.mityc.firmaJava.libreria.xades.elementos.xmldsig.X509SerialNumber;
import es.mityc.firmaJava.libreria.xades.errores.InvalidInfoNodeException;
import java.math.BigInteger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class X509IssuerSerialType
extends AbstractXDsigElement {
    private X509IssuerName issuerName;
    private X509SerialNumber serialNumber;

    public X509IssuerSerialType() {
    }

    public X509IssuerSerialType(String issuerName, BigInteger serialNumber) {
        this.issuerName = new X509IssuerName(issuerName);
        this.serialNumber = new X509SerialNumber(serialNumber);
    }

    public void setIssuerName(String issuerName) {
        this.issuerName = new X509IssuerName(issuerName);
    }

    public void setSerialNumber(BigInteger serialNumber) {
        this.serialNumber = new X509SerialNumber(serialNumber);
    }

    public String getIssuerName() {
        return this.issuerName != null ? this.issuerName.getValue() : null;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber != null ? this.serialNumber.getValue() : null;
    }

    @Override
    public void addContent(Element element, String namespaceXDsig) throws InvalidInfoNodeException {
        super.addContent(element, namespaceXDsig);
    }

    @Override
    protected void addContent(Element element) throws InvalidInfoNodeException {
        if (this.issuerName == null || this.serialNumber == null) {
            throw new InvalidInfoNodeException("Informaci\u00f3n insuficiente para escribir nodo X509IssuerSerialType");
        }
        element.appendChild(this.issuerName.createElement(element.getOwnerDocument(), this.namespaceXDsig));
        element.appendChild(this.serialNumber.createElement(element.getOwnerDocument(), this.namespaceXDsig));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof X509IssuerSerialType) {
            X509IssuerSerialType ist = (X509IssuerSerialType)obj;
            if (this.serialNumber == null || this.issuerName == null) {
                return false;
            }
            if (!this.issuerName.equals(ist.issuerName)) {
                return false;
            }
            return this.serialNumber.equals(ist.serialNumber);
        }
        return false;
    }

    @Override
    public void load(Element element) throws InvalidInfoNodeException {
        X509IssuerName name = new X509IssuerName();
        Node node = X509IssuerSerialType.getFirstNonvoidNode(element);
        if (!name.isThisNode(node)) {
            throw new InvalidInfoNodeException("Se esperaba nodo X509IssuerName en X509IssuerSerialType");
        }
        name.load((Element)node);
        node = X509IssuerSerialType.getNextNonvoidNode(node);
        X509SerialNumber serial = new X509SerialNumber(null);
        if (!serial.isThisNode(node)) {
            throw new InvalidInfoNodeException("Se esperaba nodo X509SerialNumber en X509IssuerSerialType");
        }
        serial.load((Element)node);
        this.issuerName = name;
        this.serialNumber = serial;
    }
}

