/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.libreria.xades.elementos.xades;

import es.mityc.firmaJava.libreria.utilidades.UtilidadTratarNodo;
import es.mityc.firmaJava.libreria.xades.XAdESSchemas;
import es.mityc.firmaJava.libreria.xades.elementos.xades.AbstractXADESElement;
import es.mityc.firmaJava.libreria.xades.elementos.xades.City;
import es.mityc.firmaJava.libreria.xades.elementos.xades.CountryName;
import es.mityc.firmaJava.libreria.xades.elementos.xades.PostalCode;
import es.mityc.firmaJava.libreria.xades.elementos.xades.StateOrProvince;
import es.mityc.firmaJava.libreria.xades.errores.InvalidInfoNodeException;
import org.w3c.dom.Element;

public class SignatureProductionPlaceType
extends AbstractXADESElement {
    private City city;
    private CountryName country;
    private PostalCode postal;
    private StateOrProvince province;

    public SignatureProductionPlaceType(XAdESSchemas schema) {
        super(schema);
    }

    public SignatureProductionPlaceType(XAdESSchemas schema, String city, String state, String postalCode, String country) {
        super(schema);
        if (city != null) {
            this.city = new City(schema, city);
        }
        if (state != null) {
            this.province = new StateOrProvince(schema, state);
        }
        if (postalCode != null) {
            this.postal = new PostalCode(schema, postalCode);
        }
        if (country != null) {
            this.country = new CountryName(schema, country);
        }
    }

    public String getCity() {
        if (this.city != null) {
            return this.city.getValue();
        }
        return null;
    }

    public String getCountry() {
        if (this.country != null) {
            return this.country.getValue();
        }
        return null;
    }

    public String getPostalCode() {
        if (this.postal != null) {
            return this.postal.getValue();
        }
        return null;
    }

    public String getStateOrProvince() {
        if (this.province != null) {
            return this.province.getValue();
        }
        return null;
    }

    public void setCity(String city) {
        this.city = city != null ? new City(this.schema, city) : null;
    }

    public void setCountry(String country) {
        this.country = country != null ? new CountryName(this.schema, country) : null;
    }

    public void setPostalCode(String postalCode) {
        this.postal = postalCode != null ? new PostalCode(this.schema, postalCode) : null;
    }

    public void setStateOrProvince(String stateOrProvince) {
        this.province = stateOrProvince != null ? new StateOrProvince(this.schema, stateOrProvince) : null;
    }

    @Override
    public void addContent(Element element, String namespaceXAdES) throws InvalidInfoNodeException {
        super.addContent(element, namespaceXAdES);
    }

    @Override
    protected void addContent(Element element) throws InvalidInfoNodeException {
        if (this.city != null) {
            element.appendChild(this.city.createElement(element.getOwnerDocument(), this.namespaceXAdES));
        }
        if (this.province != null) {
            element.appendChild(this.province.createElement(element.getOwnerDocument(), this.namespaceXAdES));
        }
        if (this.postal != null) {
            element.appendChild(this.postal.createElement(element.getOwnerDocument(), this.namespaceXAdES));
        }
        if (this.country != null) {
            element.appendChild(this.country.createElement(element.getOwnerDocument(), this.namespaceXAdES));
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SignatureProductionPlaceType) {
            SignatureProductionPlaceType sppt = (SignatureProductionPlaceType)obj;
            if (this.city == null ? sppt.city != null : !this.city.equals(sppt.city)) {
                return false;
            }
            if (this.country == null ? sppt.country != null : !this.country.equals(sppt.country)) {
                return false;
            }
            if (this.postal == null ? sppt.postal != null : !this.postal.equals(sppt.postal)) {
                return false;
            }
            return !(this.province == null ? sppt.province != null : !this.province.equals(sppt.province));
        }
        return false;
    }

    @Override
    public void load(Element element) throws InvalidInfoNodeException {
        Element node = UtilidadTratarNodo.getFirstElementChild(element, true);
        if (node == null) {
            return;
        }
        if (node.getNodeType() != 1) {
            throw new InvalidInfoNodeException("Se esperaba elemento como hijo de SignatureProductionPlaceType");
        }
        City cityTemp = new City(this.schema);
        Element child = node;
        if (cityTemp.isThisNode(child)) {
            cityTemp.load(child);
            this.city = cityTemp;
            node = UtilidadTratarNodo.getNextElementSibling(node, true);
        } else {
            this.city = null;
        }
        if (node == null) {
            return;
        }
        if (node.getNodeType() != 1) {
            throw new InvalidInfoNodeException("Se esperaba elemento como hijo de SignatureProductionPlaceType");
        }
        StateOrProvince stateTemp = new StateOrProvince(this.schema);
        child = node;
        if (stateTemp.isThisNode(child)) {
            stateTemp.load(child);
            this.province = stateTemp;
            node = UtilidadTratarNodo.getNextElementSibling(node, true);
        } else {
            this.province = null;
        }
        if (node == null) {
            return;
        }
        if (node.getNodeType() != 1) {
            throw new InvalidInfoNodeException("Se esperaba elemento como hijo de SignatureProductionPlaceType");
        }
        PostalCode postalTemp = new PostalCode(this.schema);
        child = node;
        if (postalTemp.isThisNode(child)) {
            postalTemp.load(child);
            this.postal = postalTemp;
            node = UtilidadTratarNodo.getNextElementSibling(node, true);
        } else {
            this.postal = null;
        }
        if (node == null) {
            return;
        }
        if (node.getNodeType() != 1) {
            throw new InvalidInfoNodeException("Se esperaba elemento como hijo de SignatureProductionPlaceType");
        }
        CountryName countryTemp = new CountryName(this.schema);
        child = node;
        if (countryTemp.isThisNode(child)) {
            countryTemp.load(child);
            this.country = countryTemp;
            node = UtilidadTratarNodo.getNextElementSibling(node, true);
        } else {
            this.country = null;
        }
        if (node != null) {
            throw new InvalidInfoNodeException("No se esperaba este elemento como hijo de SignatureProductionPlaceType");
        }
    }
}

