/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.libreria.xades.elementos.xades;

import es.mityc.firmaJava.libreria.xades.XAdESSchemas;
import es.mityc.firmaJava.libreria.xades.elementos.XMLDataURIType;
import es.mityc.firmaJava.libreria.xades.elementos.xades.AbstractXADESElement;
import es.mityc.firmaJava.libreria.xades.errores.InvalidInfoNodeException;
import java.net.URI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AbstractXadesURIElement
extends AbstractXADESElement {
    private XMLDataURIType data;
    private String nameElement;

    public AbstractXadesURIElement(XAdESSchemas schema, String nameElement, URI data) {
        super(schema);
        this.nameElement = nameElement;
        this.data = new XMLDataURIType(data);
    }

    public AbstractXadesURIElement(XAdESSchemas schema, String nameElement) {
        super(schema);
        this.nameElement = nameElement;
    }

    @Override
    protected Element createElement(Document doc) throws InvalidInfoNodeException {
        if (this.data == null) {
            throw new InvalidInfoNodeException("Informaci\u00f3n insuficiente para escribir elemento " + this.nameElement);
        }
        Element res = doc.createElementNS(this.schema.getSchemaUri(), String.valueOf(this.namespaceXAdES) + ":" + this.nameElement);
        this.data.addContent(res);
        return res;
    }

    @Override
    public Element createElement(Document doc, String namespaceXAdES) throws InvalidInfoNodeException {
        return super.createElement(doc, namespaceXAdES);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof AbstractXadesURIElement) {
            AbstractXadesURIElement desc = (AbstractXadesURIElement)obj;
            return this.nameElement.equals(desc.nameElement) && this.data.equals(desc.data);
        }
        return this.data.equals(obj);
    }

    @Override
    public void load(Element element) throws InvalidInfoNodeException {
        this.checkElementName(element, this.schema.getSchemaUri(), this.nameElement);
        this.data = new XMLDataURIType(null);
        this.data.load(element);
    }

    public void setValue(URI value) {
        if (this.data == null) {
            this.data = new XMLDataURIType(value);
        } else {
            this.data.setValue(value);
        }
    }

    public URI getValue() {
        if (this.data != null) {
            return this.data.getValue();
        }
        return null;
    }

    @Override
    public boolean isThisNode(Node node) {
        return this.isElementName(this.nodeToElement(node), this.schema.getSchemaUri(), this.nameElement);
    }
}

