/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.libreria.xades.elementos;

import es.mityc.firmaJava.libreria.utilidades.Utilidades;
import es.mityc.firmaJava.libreria.xades.elementos.AbstractXMLElement;
import es.mityc.firmaJava.libreria.xades.errores.InvalidInfoNodeException;
import org.apache.commons.lang.StringEscapeUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLDataStringType
extends AbstractXMLElement {
    protected String value;

    public XMLDataStringType(String value) {
        this.value = value;
    }

    @Override
    public void addContent(Element element) throws InvalidInfoNodeException {
        if (this.value == null) {
            throw new InvalidInfoNodeException("Informaci\u00f3n insuficiente para escribir nodo XMLDataStringType");
        }
        element.setTextContent(Utilidades.escapeXML(this.value));
    }

    @Override
    public boolean equals(Object obj) {
        String data;
        XMLDataStringType xdst;
        return obj instanceof XMLDataStringType ? this.value.equals(xdst = (XMLDataStringType)obj) : obj instanceof String && this.value.equals(data = (String)obj);
    }

    @Override
    public void load(Element element) throws InvalidInfoNodeException {
        Node node = XMLDataStringType.getFirstNonvoidNode(element);
        if (node != null && node.getNodeType() != 3) {
            throw new InvalidInfoNodeException("Nodo xsd:string no contiene CDATA como primer valor");
        }
        if (node == null) {
            this.value = new String("");
        } else {
            this.value = node.getNodeValue();
            if (this.value == null) {
                throw new InvalidInfoNodeException("Contenido de valor de xsd:string vac\u00edo");
            }
            this.value = StringEscapeUtils.unescapeXml((String)this.value);
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

