/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.libreria.xades;

import es.mityc.firmaJava.libreria.utilidades.I18n;
import es.mityc.firmaJava.libreria.utilidades.NombreNodo;
import es.mityc.firmaJava.libreria.utilidades.UtilidadTratarNodo;
import es.mityc.firmaJava.libreria.xades.errores.BadFormedSignatureException;
import es.mityc.firmaJava.libreria.xades.errores.FirmaXMLError;
import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.Element;

public class UtilidadXadesX {
    private static ArrayList<String> NODOS_DE_X = null;

    static {
        NODOS_DE_X = new ArrayList(6);
        NODOS_DE_X.add("SignatureValue");
        NODOS_DE_X.add("SignatureTimeStamp");
        NODOS_DE_X.add("CompleteCertificateRefs");
        NODOS_DE_X.add("CompleteRevocationRefs");
        NODOS_DE_X.add("AttributeCertificateRefs");
        NODOS_DE_X.add("AttributeRevocationRefs");
    }

    public static ArrayList<Element> obtenerListadoXADESX1imp(String esquemaXADES, Element firma, Element nodoSigAndRefs) throws BadFormedSignatureException, FirmaXMLError {
        ArrayList<Element> resultado = new ArrayList<Element>();
        Element signatureValueNode = null;
        ArrayList<Element> signatureValueNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo("http://www.w3.org/2000/09/xmldsig#", "SignatureValue"));
        if (signatureValueNodes.size() != 1) {
            throw new BadFormedSignatureException(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "SignatureValue" + " " + I18n.getResource("libreriaxades.firmaxml.error37") + " " + signatureValueNodes.size());
        }
        signatureValueNode = signatureValueNodes.get(0);
        resultado.add(signatureValueNode);
        Element UnsignedSignaturePropertiesElement = (Element)nodoSigAndRefs.getParentNode();
        if (!new NombreNodo(esquemaXADES, "UnsignedSignatureProperties").equals(new NombreNodo(UnsignedSignaturePropertiesElement.getNamespaceURI(), UnsignedSignaturePropertiesElement.getLocalName()))) {
            throw new BadFormedSignatureException(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error40")) + " " + "SigAndRefsTimeStamp" + " " + I18n.getResource("libreriaxades.firmaxml.error42"));
        }
        if ("http://uri.etsi.org/01903/v1.2.2#".equals(esquemaXADES) || "http://uri.etsi.org/01903/v1.1.1#".equals(esquemaXADES)) {
            NombreNodo tagName = new NombreNodo(esquemaXADES, "SignatureTimeStamp");
            ArrayList<Element> nodosSigTimeStamp = UtilidadTratarNodo.obtenerNodos(UnsignedSignaturePropertiesElement, nodoSigAndRefs, tagName);
            if (nodosSigTimeStamp.size() < 1) {
                throw new BadFormedSignatureException(I18n.getResource("libreriaxades.firmaxml.error21"));
            }
            resultado.addAll(nodosSigTimeStamp);
            tagName = new NombreNodo(esquemaXADES, "CompleteCertificateRefs");
            ArrayList<Element> nodosCompleteCertificateRefs = UtilidadTratarNodo.obtenerNodos(UnsignedSignaturePropertiesElement, nodoSigAndRefs, tagName);
            if (nodosCompleteCertificateRefs.size() != 1) {
                throw new BadFormedSignatureException(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "CompleteCertificateRefs" + " " + I18n.getResource("libreriaxades.firmaxml.error37") + " " + nodosCompleteCertificateRefs.size());
            }
            resultado.addAll(nodosCompleteCertificateRefs);
            tagName = new NombreNodo(esquemaXADES, "CompleteRevocationRefs");
            ArrayList<Element> nodosCompleteRevocationRefs = UtilidadTratarNodo.obtenerNodos(UnsignedSignaturePropertiesElement, nodoSigAndRefs, tagName);
            if (nodosCompleteRevocationRefs.size() != 1) {
                throw new BadFormedSignatureException(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "CompleteRevocationRefs" + " " + I18n.getResource("libreriaxades.firmaxml.error37") + " " + nodosCompleteRevocationRefs.size());
            }
            resultado.addAll(nodosCompleteRevocationRefs);
            if ("http://uri.etsi.org/01903/v1.2.2#".equals(esquemaXADES)) {
                ArrayList<Element> nodosAttributeRevocationRefs;
                tagName = new NombreNodo(esquemaXADES, "AttributeCertificateRefs");
                ArrayList<Element> nodosAttributeCertificateRefs = UtilidadTratarNodo.obtenerNodos(UnsignedSignaturePropertiesElement, nodoSigAndRefs, tagName);
                if (nodosAttributeCertificateRefs.size() > 1) {
                    throw new BadFormedSignatureException(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "AttributeCertificateRefs" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + nodosAttributeCertificateRefs.size());
                }
                if (nodosAttributeCertificateRefs.size() == 1) {
                    resultado.addAll(nodosAttributeCertificateRefs);
                }
                if ((nodosAttributeRevocationRefs = UtilidadTratarNodo.obtenerNodos(UnsignedSignaturePropertiesElement, nodoSigAndRefs, tagName = new NombreNodo(esquemaXADES, "AttributeRevocationRefs"))).size() > 1) {
                    throw new BadFormedSignatureException(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "AttributeRevocationRefs" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + nodosAttributeRevocationRefs.size());
                }
                if (nodosAttributeRevocationRefs.size() == 1) {
                    resultado.addAll(nodosAttributeRevocationRefs);
                }
            }
        } else {
            ArrayList<NombreNodo> nodosABuscar = new ArrayList<NombreNodo>();
            nodosABuscar.add(new NombreNodo(esquemaXADES, "SignatureTimeStamp"));
            nodosABuscar.add(new NombreNodo(esquemaXADES, "CompleteCertificateRefs"));
            nodosABuscar.add(new NombreNodo(esquemaXADES, "CompleteRevocationRefs"));
            nodosABuscar.add(new NombreNodo(esquemaXADES, "AttributeCertificateRefs"));
            nodosABuscar.add(new NombreNodo(esquemaXADES, "AttributeRevocationRefs"));
            ArrayList<Element> nodos = UtilidadTratarNodo.obtenerNodos(UnsignedSignaturePropertiesElement, nodoSigAndRefs, nodosABuscar);
            resultado.addAll(nodos);
        }
        int[] listaAparicion = new int[6];
        Iterator it = resultado.iterator();
        int indexAnterior = 0;
        while (it.hasNext()) {
            Element el = (Element)it.next();
            int index = NODOS_DE_X.indexOf(el.getLocalName());
            if ("http://uri.etsi.org/01903/v1.1.1#".equals(esquemaXADES) || "http://uri.etsi.org/01903/v1.2.2#".equals(esquemaXADES)) {
                if (index < indexAnterior) {
                    throw new BadFormedSignatureException(I18n.getResource("libreriaxades.firmaxml.error39"));
                }
                indexAnterior = index;
            }
            int n = index;
            listaAparicion[n] = listaAparicion[n] + 1;
        }
        if (listaAparicion[0] != 1 || listaAparicion[1] < 1 || listaAparicion[2] != 1 || listaAparicion[3] != 1 || listaAparicion[4] > 1 || listaAparicion[5] > 1) {
            throw new BadFormedSignatureException(I18n.getResource("libreriaxades.firmaxml.error39"));
        }
        return resultado;
    }

    public static ArrayList<Element> obtenerListadoXADESX2exp(String esquemaXADES, Element firma, Element nodoRefsOnly) throws BadFormedSignatureException, FirmaXMLError {
        ArrayList<Element> resultado = new ArrayList<Element>();
        Element UnsignedSignaturePropertiesElement = (Element)nodoRefsOnly.getParentNode();
        if (!new NombreNodo(esquemaXADES, "UnsignedSignatureProperties").equals(new NombreNodo(UnsignedSignaturePropertiesElement.getNamespaceURI(), UnsignedSignaturePropertiesElement.getLocalName()))) {
            throw new BadFormedSignatureException(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error40")) + " " + "RefsOnlyTimeStamp" + " " + I18n.getResource("libreriaxades.firmaxml.error42"));
        }
        if ("http://uri.etsi.org/01903/v1.3.2#".equals(esquemaXADES) || "http://uri.etsi.org/01903/v1.1.1#".equals(esquemaXADES)) {
            NombreNodo tagName = new NombreNodo(esquemaXADES, "CompleteCertificateRefs");
            ArrayList<Element> nodosCompleteCertificateRefs = UtilidadTratarNodo.obtenerNodos(UnsignedSignaturePropertiesElement, nodoRefsOnly, tagName);
            if (nodosCompleteCertificateRefs.size() != 1) {
                throw new BadFormedSignatureException(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "CompleteCertificateRefs" + " " + I18n.getResource("libreriaxades.firmaxml.error37") + " " + nodosCompleteCertificateRefs.size());
            }
            resultado.addAll(nodosCompleteCertificateRefs);
            tagName = new NombreNodo(esquemaXADES, "CompleteRevocationRefs");
            ArrayList<Element> nodosCompleteRevocationRefs = UtilidadTratarNodo.obtenerNodos(UnsignedSignaturePropertiesElement, nodoRefsOnly, tagName);
            if (nodosCompleteRevocationRefs.size() != 1) {
                throw new BadFormedSignatureException(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "CompleteRevocationRefs" + " " + I18n.getResource("libreriaxades.firmaxml.error37") + " " + nodosCompleteRevocationRefs.size());
            }
            resultado.addAll(nodosCompleteRevocationRefs);
            if ("http://uri.etsi.org/01903/v1.2.2#".equals(esquemaXADES)) {
                ArrayList<Element> nodosAttributeRevocationRefs;
                tagName = new NombreNodo(esquemaXADES, "AttributeCertificateRefs");
                ArrayList<Element> nodosAttributeCertificateRefs = UtilidadTratarNodo.obtenerNodos(UnsignedSignaturePropertiesElement, nodoRefsOnly, tagName);
                if (nodosAttributeCertificateRefs.size() > 1) {
                    throw new BadFormedSignatureException(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "AttributeCertificateRefs" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + nodosAttributeCertificateRefs.size());
                }
                if (nodosAttributeCertificateRefs.size() == 1) {
                    resultado.addAll(nodosAttributeCertificateRefs);
                }
                if ((nodosAttributeRevocationRefs = UtilidadTratarNodo.obtenerNodos(UnsignedSignaturePropertiesElement, nodoRefsOnly, tagName = new NombreNodo(esquemaXADES, "AttributeRevocationRefs"))).size() > 1) {
                    throw new BadFormedSignatureException(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "AttributeRevocationRefs" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + nodosAttributeRevocationRefs.size());
                }
                if (nodosAttributeRevocationRefs.size() == 1) {
                    resultado.addAll(nodosAttributeRevocationRefs);
                }
            }
        } else {
            ArrayList<NombreNodo> nodosABuscar = new ArrayList<NombreNodo>();
            nodosABuscar.add(new NombreNodo(esquemaXADES, "CompleteCertificateRefs"));
            nodosABuscar.add(new NombreNodo(esquemaXADES, "CompleteRevocationRefs"));
            nodosABuscar.add(new NombreNodo(esquemaXADES, "AttributeCertificateRefs"));
            nodosABuscar.add(new NombreNodo(esquemaXADES, "AttributeRevocationRefs"));
            ArrayList<Element> nodos = UtilidadTratarNodo.obtenerNodos(UnsignedSignaturePropertiesElement, nodoRefsOnly, nodosABuscar);
            resultado.addAll(nodos);
        }
        int[] listaAparicion = new int[6];
        Iterator it = resultado.iterator();
        int indexAnterior = 0;
        while (it.hasNext()) {
            Element el = (Element)it.next();
            int index = NODOS_DE_X.indexOf(el.getLocalName());
            if ("http://uri.etsi.org/01903/v1.1.1#".equals(esquemaXADES) || "http://uri.etsi.org/01903/v1.2.2#".equals(esquemaXADES)) {
                if (index < indexAnterior) {
                    throw new BadFormedSignatureException(I18n.getResource("libreriaxades.firmaxml.error39"));
                }
                indexAnterior = index;
            }
            int n = index;
            listaAparicion[n] = listaAparicion[n] + 1;
        }
        if (listaAparicion[0] != 0 || listaAparicion[1] != 0 || listaAparicion[2] != 1 || listaAparicion[3] != 1 || listaAparicion[4] > 1 || listaAparicion[5] > 1) {
            throw new BadFormedSignatureException(I18n.getResource("libreriaxades.firmaxml.error39"));
        }
        return resultado;
    }
}

