/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.libreria.xades;

import adsi.org.apache.xml.security.exceptions.XMLSecurityException;
import adsi.org.apache.xml.security.signature.ObjectContainer;
import adsi.org.apache.xml.security.signature.Reference;
import adsi.org.apache.xml.security.signature.SignedInfo;
import adsi.org.apache.xml.security.signature.XMLSignature;
import es.mityc.firmaJava.libreria.utilidades.I18n;
import es.mityc.firmaJava.libreria.utilidades.NombreNodo;
import es.mityc.firmaJava.libreria.utilidades.UtilidadTratarNodo;
import es.mityc.firmaJava.libreria.xades.CanonicalizationEnum;
import es.mityc.firmaJava.libreria.xades.errores.BadFormedSignatureException;
import es.mityc.firmaJava.libreria.xades.errores.FirmaXMLError;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UtilidadXadesA {
    private static Log log = LogFactory.getLog(UtilidadXadesA.class);
    private static ArrayList<String> LISTA_ELEMENTOS_UNSIGNED_FOR_DIGEST = new ArrayList();

    static {
        LISTA_ELEMENTOS_UNSIGNED_FOR_DIGEST.add("SignatureTimeStamp");
        LISTA_ELEMENTOS_UNSIGNED_FOR_DIGEST.add("CounterSignature");
        LISTA_ELEMENTOS_UNSIGNED_FOR_DIGEST.add("CompleteCertificateRefs");
        LISTA_ELEMENTOS_UNSIGNED_FOR_DIGEST.add("CompleteRevocationRefs");
        LISTA_ELEMENTOS_UNSIGNED_FOR_DIGEST.add("AttributeCertificateRefs");
        LISTA_ELEMENTOS_UNSIGNED_FOR_DIGEST.add("AttributeRevocationRefs");
        LISTA_ELEMENTOS_UNSIGNED_FOR_DIGEST.add("SigAndRefsTimeStamp");
        LISTA_ELEMENTOS_UNSIGNED_FOR_DIGEST.add("RefsOnlyTimeStamp");
        LISTA_ELEMENTOS_UNSIGNED_FOR_DIGEST.add("CertificateValues");
        LISTA_ELEMENTOS_UNSIGNED_FOR_DIGEST.add("RevocationValues");
        LISTA_ELEMENTOS_UNSIGNED_FOR_DIGEST.add("AttrAuthoritiesCertValues");
        LISTA_ELEMENTOS_UNSIGNED_FOR_DIGEST.add("AttributeRevocationValues");
        LISTA_ELEMENTOS_UNSIGNED_FOR_DIGEST.add("ArchiveTimeStamp");
    }

    public static byte[] obtenerListadoXadesA(String esquemaURI, XMLSignature xmlSig, Element selloA) throws BadFormedSignatureException, FirmaXMLError, XMLSecurityException, IOException {
        ArrayList<Element> referenceNodes;
        Element nodoCanonicalizationMethod;
        String meth;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SignedInfo si = xmlSig.getSignedInfo();
        Element firma = xmlSig.getElement();
        CanonicalizationEnum cannon = null;
        NodeList nodosCanonicalizationMethod = selloA.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "CanonicalizationMethod");
        int numNodosCanonicalization = nodosCanonicalizationMethod.getLength();
        if (numNodosCanonicalization > 0 && (cannon = CanonicalizationEnum.getCanonicalization(meth = (nodoCanonicalizationMethod = (Element)nodosCanonicalizationMethod.item(0)).getAttribute("Algorithm"))).equals((Object)CanonicalizationEnum.UNKNOWN)) {
            cannon = CanonicalizationEnum.C14N_OMIT_COMMENTS;
        }
        if (cannon == null && ((cannon = CanonicalizationEnum.getCanonicalization(si.getCanonicalizationMethodURI())) == null || CanonicalizationEnum.UNKNOWN.equals((Object)cannon))) {
            log.warn((Object)("No se reconoce el algoritmo de canonicalizaci\u00f3n " + si.getCanonicalizationMethodURI() + ". Se toma el valor por defecto."));
            cannon = CanonicalizationEnum.C14N_OMIT_COMMENTS;
        }
        if ((referenceNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo("http://www.w3.org/2000/09/xmldsig#", "Reference"))).size() == 0) {
            throw new BadFormedSignatureException(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "Reference" + " " + I18n.getResource("libreriaxades.firmaxml.error37") + " " + referenceNodes.size());
        }
        Reference referenceNode = null;
        int i = 0;
        while (i < si.getLength()) {
            referenceNode = si.item(i);
            if (referenceNode != null) {
                Element nodo;
                Element reference = referenceNodes.get(i);
                String referenceUri = reference.getAttribute("URI");
                if (referenceUri != "" && !referenceUri.startsWith("#")) {
                    File firmado = new File(referenceUri);
                    FileInputStream fis = null;
                    try {
                        fis = new FileInputStream(firmado);
                    }
                    catch (FileNotFoundException e1) {
                        throw new IOException(I18n.getResource("libreriaxades.validarfirmaxml.error58"));
                    }
                    byte[] entrada = null;
                    fis.read(entrada);
                    baos.write(entrada);
                } else if (referenceUri != "" && (nodo = UtilidadTratarNodo.getElementById(xmlSig.getDocument(), referenceUri.substring(1))) != null) {
                    baos.write(UtilidadTratarNodo.obtenerByte(nodo, UtilidadXadesA.obtenerCanonicalization(nodo, cannon)));
                }
            }
            ++i;
        }
        ArrayList<Element> signedInfoNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo("http://www.w3.org/2000/09/xmldsig#", "SignedInfo"));
        if (signedInfoNodes.size() != 1) {
            throw new BadFormedSignatureException(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "SignedInfo" + " " + I18n.getResource("libreriaxades.firmaxml.error37") + " " + signedInfoNodes.size());
        }
        baos.write(si.getCanonicalizedOctetStream());
        Element signatureValueNode = null;
        ArrayList<Element> signatureValueNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo("http://www.w3.org/2000/09/xmldsig#", "SignatureValue"));
        if (signatureValueNodes.size() != 1) {
            throw new BadFormedSignatureException(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "SignatureValue" + " " + I18n.getResource("libreriaxades.firmaxml.error37") + " " + signatureValueNodes.size());
        }
        signatureValueNode = signatureValueNodes.get(0);
        baos.write(UtilidadTratarNodo.obtenerByte(signatureValueNode, UtilidadXadesA.obtenerCanonicalization(signatureValueNode, cannon)));
        Element keyInfoNode = null;
        ArrayList<Element> keyInfoNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo("http://www.w3.org/2000/09/xmldsig#", "KeyInfo"));
        if (keyInfoNodes.size() != 1) {
            throw new BadFormedSignatureException(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "KeyInfo" + " " + I18n.getResource("libreriaxades.firmaxml.error37") + " " + keyInfoNodes.size());
        }
        keyInfoNode = keyInfoNodes.get(0);
        baos.write(UtilidadTratarNodo.obtenerByte(keyInfoNode, UtilidadXadesA.obtenerCanonicalization(keyInfoNode, cannon)));
        Element unsignedSignaturePropertiesNode = null;
        ArrayList<Element> unsignedSignaturePropertiesNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "UnsignedSignatureProperties"));
        if (unsignedSignaturePropertiesNodes.size() != 1) {
            throw new BadFormedSignatureException(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "UnsignedSignatureProperties" + " " + I18n.getResource("libreriaxades.firmaxml.error37") + " " + unsignedSignaturePropertiesNodes.size());
        }
        unsignedSignaturePropertiesNode = unsignedSignaturePropertiesNodes.get(0);
        UtilidadXadesA.validaUnsignedProperties(unsignedSignaturePropertiesNode, esquemaURI);
        NodeList unsignedPropertiesElements = unsignedSignaturePropertiesNode.getChildNodes();
        int unsignedLength = unsignedPropertiesElements.getLength();
        int i2 = 0;
        while (i2 < unsignedLength) {
            Node currentUnsignedProperty = unsignedPropertiesElements.item(i2);
            if (!(UtilidadTratarNodo.obtenerNombreNodo(currentUnsignedProperty).equalsIgnoreCase("ArchiveTimeStamp") && selloA != null && selloA.equals(currentUnsignedProperty) || (currentUnsignedProperty = UtilidadXadesA.procesarUnsignedProperty(currentUnsignedProperty)) == null)) {
                baos.write(UtilidadTratarNodo.obtenerByte((Element)currentUnsignedProperty, UtilidadXadesA.obtenerCanonicalization((Element)currentUnsignedProperty, cannon)));
            }
            ++i2;
        }
        ObjectContainer object = null;
        Element reference = null;
        String objectId = null;
        String referenceUri = null;
        int i3 = 0;
        while (i3 < xmlSig.getObjectLength()) {
            object = xmlSig.getObjectItem(i3);
            objectId = object.getId();
            boolean incluir = true;
            int j = 0;
            while (j < referenceNodes.size()) {
                reference = referenceNodes.get(j);
                referenceUri = reference.getAttribute("URI");
                if (referenceUri != null && referenceUri.length() > 0 && referenceUri.substring(1).equals(objectId)) {
                    incluir = false;
                    break;
                }
                ++j;
            }
            ArrayList<Element> qualifyingProp = UtilidadTratarNodo.obtenerNodos(firma, 2, new NombreNodo(esquemaURI, "QualifyingProperties"));
            int j2 = 0;
            while (j2 < qualifyingProp.size() && incluir) {
                ArrayList<Element> sp = UtilidadTratarNodo.obtenerNodos(object.getElement(), 2, new NombreNodo(esquemaURI, qualifyingProp.get(0).getLocalName()));
                if (sp != null && sp.size() > 0 && sp.get(0).equals(qualifyingProp.get(0))) {
                    incluir = false;
                }
                ++j2;
            }
            if (incluir) {
                baos.write(UtilidadTratarNodo.obtenerByte(object.getElement(), UtilidadXadesA.obtenerCanonicalization(object.getElement(), cannon)));
            }
            ++i3;
        }
        return baos.toByteArray();
    }

    private static Node procesarUnsignedProperty(Node currentUnsignedProperty) {
        String nombreNodo = UtilidadTratarNodo.obtenerNombreNodo(currentUnsignedProperty);
        if (LISTA_ELEMENTOS_UNSIGNED_FOR_DIGEST.contains(nombreNodo)) {
            return currentUnsignedProperty;
        }
        return null;
    }

    private static boolean validaUnsignedProperties(Element unsignedSignaturePropertiesNode, String esquemaURI) throws BadFormedSignatureException, FirmaXMLError {
        int numAttributeRevocationValues;
        int numAttrAuthoritiesCertValues;
        int numAttributeCertificateRefs;
        ArrayList<Element> completeRevocationRefsNodes;
        int numCompleteRevocationRefs;
        ArrayList<Element> completeCertificateRefsNodes = UtilidadTratarNodo.obtenerNodos(unsignedSignaturePropertiesNode, 5, new NombreNodo(esquemaURI, "CompleteCertificateRefs"));
        int numCompleteCertificateRefs = completeCertificateRefsNodes.size();
        if (numCompleteCertificateRefs > 1) {
            throw new BadFormedSignatureException(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "CompleteCertificateRefs" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + numCompleteCertificateRefs);
        }
        int numCompleteCertificateRefsChilds = 0;
        if (numCompleteCertificateRefs == 1) {
            numCompleteCertificateRefsChilds = completeCertificateRefsNodes.get(0).getChildNodes().getLength();
        }
        if ((numCompleteRevocationRefs = (completeRevocationRefsNodes = UtilidadTratarNodo.obtenerNodos(unsignedSignaturePropertiesNode, 5, new NombreNodo(esquemaURI, "CompleteRevocationRefs"))).size()) > 1) {
            throw new BadFormedSignatureException(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "CompleteRevocationRefs" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + numCompleteRevocationRefs);
        }
        int numCompleteRevocationRefsChilds = 0;
        if (numCompleteRevocationRefs == 1) {
            numCompleteRevocationRefsChilds = completeRevocationRefsNodes.get(0).getChildNodes().getLength();
        }
        if ((numAttributeCertificateRefs = UtilidadTratarNodo.obtenerNodos(unsignedSignaturePropertiesNode, 5, new NombreNodo(esquemaURI, "AttributeCertificateRefs")).size()) > 1) {
            throw new BadFormedSignatureException(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "AttributeCertificateRefs" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + numAttributeCertificateRefs);
        }
        int numAttributeRevocationRefs = UtilidadTratarNodo.obtenerNodos(unsignedSignaturePropertiesNode, 5, new NombreNodo(esquemaURI, "AttributeRevocationRefs")).size();
        if (numAttributeRevocationRefs > 1) {
            throw new BadFormedSignatureException(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "AttributeRevocationRefs" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + numAttributeRevocationRefs);
        }
        int numSigAndRefsTimeStamp = UtilidadTratarNodo.obtenerNodos(unsignedSignaturePropertiesNode, 5, new NombreNodo(esquemaURI, "SigAndRefsTimeStamp")).size();
        if (numSigAndRefsTimeStamp > 1) {
            throw new BadFormedSignatureException(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "SigAndRefsTimeStamp" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + numSigAndRefsTimeStamp);
        }
        int numRefsOnlyTimeStamp = UtilidadTratarNodo.obtenerNodos(unsignedSignaturePropertiesNode, 5, new NombreNodo(esquemaURI, "RefsOnlyTimeStamp")).size();
        if (numRefsOnlyTimeStamp > 1) {
            throw new BadFormedSignatureException(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "RefsOnlyTimeStamp" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + numRefsOnlyTimeStamp);
        }
        ArrayList<Element> certificateValuesNodes = UtilidadTratarNodo.obtenerNodos(unsignedSignaturePropertiesNode, 5, new NombreNodo(esquemaURI, "CertificateValues"));
        int numCertificateValues = certificateValuesNodes.size();
        if (numCertificateValues != 1) {
            throw new BadFormedSignatureException(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "CertificateValues" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + numCertificateValues);
        }
        int numCertificateValuesChilds = certificateValuesNodes.get(0).getChildNodes().getLength();
        ArrayList<Element> revocationValuesNodes = UtilidadTratarNodo.obtenerNodos(unsignedSignaturePropertiesNode, 5, new NombreNodo(esquemaURI, "RevocationValues"));
        int numRevocationValues = revocationValuesNodes.size();
        if (numRevocationValues != 1) {
            throw new BadFormedSignatureException(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "RevocationValues" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + numRevocationValues);
        }
        int numRevocationValuesChilds = revocationValuesNodes.get(0).getChildNodes().getLength();
        if (numAttributeCertificateRefs > 0 && numCertificateValuesChilds < numCompleteCertificateRefsChilds && (numAttrAuthoritiesCertValues = UtilidadTratarNodo.obtenerNodos(unsignedSignaturePropertiesNode, 5, new NombreNodo(esquemaURI, "AttrAuthoritiesCertValues")).size()) != 1) {
            throw new BadFormedSignatureException(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "AttrAuthoritiesCertValues" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + numAttrAuthoritiesCertValues);
        }
        if (numAttributeCertificateRefs > 0 && numRevocationValuesChilds < numCompleteRevocationRefsChilds && (numAttributeRevocationValues = UtilidadTratarNodo.obtenerNodos(unsignedSignaturePropertiesNode, 5, new NombreNodo(esquemaURI, "AttributeRevocationValues")).size()) != 1) {
            throw new BadFormedSignatureException(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "AttributeRevocationValues" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + numAttributeRevocationValues);
        }
        return true;
    }

    private static CanonicalizationEnum obtenerCanonicalization(Element nodo, CanonicalizationEnum porDefecto) throws FirmaXMLError {
        Element nodoCanonicalizationMethod;
        String method;
        NodeList nodosCanonicalizationMethod = nodo.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "CanonicalizationMethod");
        int numNodosCanonicalization = nodosCanonicalizationMethod.getLength();
        CanonicalizationEnum canonicalization = porDefecto;
        if (numNodosCanonicalization > 0 && (canonicalization = CanonicalizationEnum.getCanonicalization(method = (nodoCanonicalizationMethod = (Element)nodosCanonicalizationMethod.item(0)).getAttribute("Algorithm"))).equals((Object)CanonicalizationEnum.UNKNOWN)) {
            throw new FirmaXMLError(String.valueOf(I18n.getResource("libreriaxades.validarfirmaxml.error103")) + " " + method);
        }
        return canonicalization;
    }

    public static ArrayList<String> obtenerListadoIdsElementosXadesA(String esquemaURI, XMLSignature xmlSig, Element selloA) throws BadFormedSignatureException, FirmaXMLError, XMLSecurityException {
        ArrayList<String> input = new ArrayList<String>();
        SignedInfo si = xmlSig.getSignedInfo();
        Element firma = xmlSig.getElement();
        ArrayList<Element> referenceNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo("http://www.w3.org/2000/09/xmldsig#", "Reference"));
        if (referenceNodes.size() == 0) {
            throw new BadFormedSignatureException(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "Reference" + " " + I18n.getResource("libreriaxades.firmaxml.error37") + " " + referenceNodes.size());
        }
        Reference referenceNode = null;
        int i = 0;
        while (i < referenceNodes.size()) {
            referenceNode = si.item(i);
            String idRef = referenceNode.getElement().getAttribute("Id");
            if (idRef == null) {
                throw new BadFormedSignatureException("No se puede recuperar la Id del nodo Reference");
            }
            input.add("#" + idRef);
            ++i;
        }
        Element signedInfoNode = null;
        ArrayList<Element> signedInfoNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo("http://www.w3.org/2000/09/xmldsig#", "SignedInfo"));
        if (signedInfoNodes.size() != 1) {
            throw new BadFormedSignatureException(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "SignedInfo" + " " + I18n.getResource("libreriaxades.firmaxml.error37") + " " + signedInfoNodes.size());
        }
        signedInfoNode = signedInfoNodes.get(0);
        String idSigInfo = signedInfoNode.getAttribute("Id");
        if (idSigInfo == null) {
            throw new BadFormedSignatureException("No se puede recuperar la ID del nodo SignedInfo");
        }
        input.add("#" + idSigInfo);
        Element signatureValueNode = null;
        ArrayList<Element> signatureValueNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo("http://www.w3.org/2000/09/xmldsig#", "SignatureValue"));
        if (signatureValueNodes.size() != 1) {
            throw new BadFormedSignatureException(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "SignatureValue" + " " + I18n.getResource("libreriaxades.firmaxml.error37") + " " + signatureValueNodes.size());
        }
        signatureValueNode = signatureValueNodes.get(0);
        String idSigValue = signatureValueNode.getAttribute("Id");
        if (idSigValue == null) {
            throw new BadFormedSignatureException("No se puede recuperar la ID del nodo SignatureValue");
        }
        input.add("#" + idSigValue);
        Element keyInfoNode = null;
        ArrayList<Element> keyInfoNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo("http://www.w3.org/2000/09/xmldsig#", "KeyInfo"));
        if (keyInfoNodes.size() != 1) {
            throw new BadFormedSignatureException(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "KeyInfo" + " " + I18n.getResource("libreriaxades.firmaxml.error37") + " " + keyInfoNodes.size());
        }
        keyInfoNode = keyInfoNodes.get(0);
        String idKeyInfo = keyInfoNode.getAttribute("Id");
        if (idKeyInfo == null) {
            throw new BadFormedSignatureException("No se puede recuperar la ID del nodo KeyInfo");
        }
        input.add("#" + idKeyInfo);
        ArrayList<Element> nodosSigTimeStamp = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "SignatureTimeStamp"));
        if (nodosSigTimeStamp.size() < 1) {
            throw new BadFormedSignatureException(I18n.getResource("libreriaxades.firmaxml.error21"));
        }
        int i2 = 0;
        while (i2 < nodosSigTimeStamp.size()) {
            String idSigTimeStamp = nodosSigTimeStamp.get(i2).getAttribute("Id");
            if (idSigTimeStamp == null) {
                throw new BadFormedSignatureException("No se puede recuperar la ID de un sello de tiempo XAdES-T");
            }
            input.add("#" + idSigTimeStamp);
            ++i2;
        }
        ArrayList<Element> counterSignatureNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "CounterSignature"));
        int i3 = 0;
        while (i3 < counterSignatureNodes.size()) {
            String idCounterSig = counterSignatureNodes.get(i3).getAttribute("Id");
            if (idCounterSig == null) {
                throw new BadFormedSignatureException("No se puede recuperar la ID de una contrafirma");
            }
            input.add("#" + idCounterSig);
            ++i3;
        }
        ArrayList<Element> completeCertificateRefsNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "CompleteCertificateRefs"));
        if (completeCertificateRefsNodes.size() > 1) {
            throw new BadFormedSignatureException(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "CompleteCertificateRefs" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + completeCertificateRefsNodes.size());
        }
        int i4 = 0;
        while (i4 < completeCertificateRefsNodes.size()) {
            String idCompCertRef = completeCertificateRefsNodes.get(i4).getAttribute("Id");
            if (idCompCertRef == null) {
                throw new BadFormedSignatureException("No se puede recuperar la ID del nodo CompleteCertificateRefs");
            }
            input.add("#" + idCompCertRef);
            ++i4;
        }
        ArrayList<Element> completeRevocationRefsNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "CompleteRevocationRefs"));
        if (completeRevocationRefsNodes.size() > 1) {
            throw new BadFormedSignatureException(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "CompleteRevocationRefs" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + completeRevocationRefsNodes.size());
        }
        int i5 = 0;
        while (i5 < completeRevocationRefsNodes.size()) {
            String idCompRevRef = completeRevocationRefsNodes.get(i5).getAttribute("Id");
            if (idCompRevRef == null) {
                throw new BadFormedSignatureException("No se puede recuperar la ID del nodo CompleteRevocationRefs");
            }
            input.add("#" + idCompRevRef);
            ++i5;
        }
        ArrayList<Element> attributeCertificateRefsNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "AttributeCertificateRefs"));
        if (attributeCertificateRefsNodes.size() > 1) {
            throw new BadFormedSignatureException(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "AttributeCertificateRefs" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + attributeCertificateRefsNodes.size());
        }
        int i6 = 0;
        while (i6 < attributeCertificateRefsNodes.size()) {
            String idAttrCertRef = attributeCertificateRefsNodes.get(i6).getAttribute("Id");
            if (idAttrCertRef == null) {
                throw new BadFormedSignatureException("No se puede recuperar la ID del nodo AttributeCertificateRefs");
            }
            input.add("#" + idAttrCertRef);
            ++i6;
        }
        ArrayList<Element> attributeRevocationRefsNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "AttributeRevocationRefs"));
        if (attributeRevocationRefsNodes.size() > 1) {
            throw new BadFormedSignatureException(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "AttributeRevocationRefs" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + attributeRevocationRefsNodes.size());
        }
        int i7 = 0;
        while (i7 < attributeRevocationRefsNodes.size()) {
            String idAttrRevRef = attributeRevocationRefsNodes.get(i7).getAttribute("Id");
            if (idAttrRevRef == null) {
                throw new BadFormedSignatureException("No se puede recuperar la ID del nodo AttributeRevocationRefs");
            }
            input.add("#" + idAttrRevRef);
            ++i7;
        }
        ArrayList<Element> sigAndRefsTimeStampNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "SigAndRefsTimeStamp"));
        if (sigAndRefsTimeStampNodes.size() > 1) {
            throw new BadFormedSignatureException(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "AttributeRevocationRefs" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + sigAndRefsTimeStampNodes.size());
        }
        int i8 = 0;
        while (i8 < sigAndRefsTimeStampNodes.size()) {
            String idSigAndRefs = sigAndRefsTimeStampNodes.get(i8).getAttribute("Id");
            if (idSigAndRefs == null) {
                throw new BadFormedSignatureException("No se puede recuperar la ID del nodo SigAndRefsTimeStamp");
            }
            input.add("#" + idSigAndRefs);
            ++i8;
        }
        ArrayList<Element> refsOnlyTimeStampNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "RefsOnlyTimeStamp"));
        if (refsOnlyTimeStampNodes.size() > 1) {
            throw new BadFormedSignatureException(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "AttributeRevocationRefs" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + refsOnlyTimeStampNodes.size());
        }
        int i9 = 0;
        while (i9 < refsOnlyTimeStampNodes.size()) {
            String refsOnlyTimeStamp = refsOnlyTimeStampNodes.get(i9).getAttribute("Id");
            if (refsOnlyTimeStamp == null) {
                throw new BadFormedSignatureException("No se puede recuperar la ID del nodo RefsOnlyTimeStamp");
            }
            input.add("#" + refsOnlyTimeStamp);
            ++i9;
        }
        ArrayList<Element> certificateValuesNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "CertificateValues"));
        if (certificateValuesNodes.size() != 1) {
            throw new BadFormedSignatureException(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "CertificateValues" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + certificateValuesNodes.size());
        }
        String certValueId = certificateValuesNodes.get(0).getAttribute("Id");
        if (certValueId == null) {
            throw new BadFormedSignatureException("No se puede recuperar la ID del nodo CertificateValues");
        }
        input.add("#" + certValueId);
        ArrayList<Element> revocationValuesNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "RevocationValues"));
        if (revocationValuesNodes.size() != 1) {
            throw new BadFormedSignatureException(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "RevocationValues" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + revocationValuesNodes.size());
        }
        String revValuesId = revocationValuesNodes.get(0).getAttribute("Id");
        if (revValuesId == null) {
            throw new BadFormedSignatureException("No se puede recuperar la ID del nodo RevocationValues");
        }
        input.add("#" + revValuesId);
        ArrayList<Element> archiveTimeStampNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "ArchiveTimeStamp"));
        int i10 = 0;
        while (i10 < archiveTimeStampNodes.size()) {
            Element selloANode = archiveTimeStampNodes.get(i10);
            if (selloA != null && selloA.equals(selloANode)) break;
            String aTimeStampId = selloANode.getAttribute("Id");
            if (aTimeStampId == null) {
                throw new BadFormedSignatureException("No se puede recuperar la ID del nodo ArchiveTimeStamp");
            }
            input.add("#" + aTimeStampId);
            ++i10;
        }
        ObjectContainer object = null;
        Element reference = null;
        String objectId = null;
        String referenceUri = null;
        int i11 = 0;
        while (i11 < xmlSig.getObjectLength()) {
            object = xmlSig.getObjectItem(i11);
            objectId = object.getId();
            boolean incluir = true;
            int j = 0;
            while (j < referenceNodes.size()) {
                reference = referenceNodes.get(j);
                referenceUri = reference.getAttribute("URI");
                if (referenceUri != null && referenceUri.length() > 0 && referenceUri.substring(1).equals(objectId)) {
                    incluir = false;
                    break;
                }
                ++j;
            }
            ArrayList<Element> quialifyingProp = UtilidadTratarNodo.obtenerNodos(firma, 2, new NombreNodo(esquemaURI, "QualifyingProperties"));
            int j2 = 0;
            while (j2 < quialifyingProp.size() && incluir) {
                if (quialifyingProp.get(j2).equals(object.getElement().getFirstChild())) {
                    incluir = false;
                }
                ++j2;
            }
            if (incluir) {
                String objectNodeId = object.getElement().getAttribute("Id");
                if (objectNodeId == null) {
                    throw new BadFormedSignatureException("No se puede recuperar la ID del nodo Object");
                }
                input.add("#" + objectNodeId);
            }
            ++i11;
        }
        return input;
    }

    public static ArrayList<String> casoDistribuido() {
        ArrayList<String> input = new ArrayList<String>();
        return input;
    }
}

