/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.libreria.xades;

import es.mityc.firmaJava.libreria.utilidades.Base64Coder;
import es.mityc.firmaJava.trust.ConfianzaEnum;
import es.mityc.javasign.certificate.ICertStatus;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ocsp.ResponderID;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.ocsp.BasicOCSPResp;
import org.bouncycastle.ocsp.OCSPResp;

public class DatosOCSP {
    private ResponderID responderId = null;
    private String responderIdName = null;
    private Date fechaConsulta = null;
    private String certConsultado = null;
    private OCSPResp respuestaOCSP = null;
    private BasicOCSPResp basicOCSPResp = null;
    private ConfianzaEnum esCertConfianza = ConfianzaEnum.NO_REVISADO;
    private ICertStatus.CERT_STATUS revockedStatus = ICertStatus.CERT_STATUS.unknown;
    private ICertStatus status = null;
    private X509Certificate[] certOCSPResponder = null;

    public DatosOCSP() {
    }

    public DatosOCSP(ResponderID responderId, Date fechaConsulta, String certConsultado, OCSPResp respuestaOCSP, ConfianzaEnum esCertConfianza, X509Certificate[] certOCSPResponder) {
        this.responderId = responderId;
        this.updateResponderIDName(responderId);
        this.fechaConsulta = fechaConsulta;
        this.certConsultado = certConsultado;
        this.respuestaOCSP = respuestaOCSP;
        this.esCertConfianza = esCertConfianza;
        this.esCertConfianza = esCertConfianza;
        this.certOCSPResponder = certOCSPResponder;
    }

    public ResponderID getResponderId() {
        return this.responderId;
    }

    public void setResponderId(ResponderID responderId) {
        this.responderId = responderId;
        this.updateResponderIDName(responderId);
    }

    private void updateResponderIDName(ResponderID responderId) {
        if (responderId != null) {
            ASN1TaggedObject tagged = (ASN1TaggedObject)responderId.toASN1Object();
            switch (tagged.getTagNo()) {
                case 1: {
                    X509Principal certX509Principal = new X509Principal(X509Name.getInstance((Object)tagged.getObject()).toString());
                    X500Principal cerX500Principal = new X500Principal(certX509Principal.getDEREncoded());
                    this.responderIdName = cerX500Principal.getName();
                    break;
                }
                case 2: {
                    ASN1OctetString octect = (ASN1OctetString)tagged.getObject();
                    this.responderIdName = new String(Base64Coder.encode(octect.getOctets()));
                }
            }
        } else {
            this.responderIdName = null;
        }
    }

    public String getResponderIdName() {
        return this.responderIdName;
    }

    public String getCertConsultado() {
        return this.certConsultado;
    }

    public void setCertConsultado(String certConsultado) {
        this.certConsultado = certConsultado;
    }

    public Date getFechaConsulta() {
        return this.fechaConsulta;
    }

    public void setFechaConsulta(Date fechaConsulta) {
        this.fechaConsulta = fechaConsulta;
    }

    public OCSPResp getRespuestaOCSP() {
        return this.respuestaOCSP;
    }

    public void setRespuestaOCSP(OCSPResp respuestaOCSP) {
        this.respuestaOCSP = respuestaOCSP;
    }

    public ConfianzaEnum esCertConfianza() {
        return this.esCertConfianza;
    }

    public void setEsCertConfianza(ConfianzaEnum esCertConfianza) {
        this.esCertConfianza = esCertConfianza;
    }

    public X509Certificate[] getCertOCSPResponder() {
        return this.certOCSPResponder;
    }

    public void setCertOCSPResponder(X509Certificate[] certOCSPResponder) {
        this.certOCSPResponder = certOCSPResponder;
    }

    public ICertStatus.CERT_STATUS getRevockedStatus() {
        return this.revockedStatus;
    }

    public void setRevockedStatus(ICertStatus.CERT_STATUS revockedStatus) {
        this.revockedStatus = revockedStatus;
    }

    public BasicOCSPResp getBasicRespuestaOCSP() {
        return this.basicOCSPResp;
    }

    public void setBasicRespuestaOCSP(BasicOCSPResp basicOCSPResp) {
        this.basicOCSPResp = basicOCSPResp;
    }

    public ICertStatus getStatus() {
        return this.status;
    }

    public void setStatus(ICertStatus status) {
        this.status = status;
    }
}

