/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.trust;

import es.mityc.crypto.symetric.TripleDESManager;
import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.util.Properties;

public class Utils {
    private static II18nManager i18n = I18nFactory.getI18nManager((String)"MITyCLibTrust");
    private static byte[] pass = new byte[]{100, 87, 39, 78, 66, 55, 100, 75, 77, 114, 97, 85, 35, 119, 53, 64, 109, 98, 88, 37, 123, 44, 83, 88, 51, 103, 95, 94, 70, 40, 48, 104, 82, 66, 60, 70, 74, 118, 36, 55, 105, 98, 37, 73, 71, 34, 80, 75, 67, 63, 87, 114, 39};

    public static void setPass(byte[] password) {
        pass = password;
    }

    public static String getMD5(X509Certificate cert) throws Exception {
        MessageDigest certDigest = MessageDigest.getInstance("MD5");
        byte[] digestByte = certDigest.digest(cert.getEncoded());
        StringBuffer sb = new StringBuffer("");
        int i = 0;
        while (i < digestByte.length) {
            sb.append(Integer.toString((digestByte[i] & 0xFF) + 256, 16).substring(1));
            ++i;
        }
        return sb.toString();
    }

    public static void protectConf(Properties conf, String path) throws SecurityException {
        if (pass == null || "".equals(new String(pass).trim()) || conf == null) {
            throw new SecurityException(i18n.getLocalMessage("i18n.mityc.trust.utils.1"));
        }
        TripleDESManager p = new TripleDESManager();
        String confText = conf.toString();
        confText = confText.substring(1, confText.lastIndexOf(125)).replace(',', '\n').replace('\\', '/');
        byte[] plainProps = confText.getBytes();
        char[] bufferChar = p.protectTripleDES(plainProps, new String(pass));
        String protectedConf = new String(bufferChar);
        try {
            File protectedFile = new File(path);
            FileWriter w = new FileWriter(protectedFile);
            w.write(protectedConf);
            ((Writer)w).close();
        }
        catch (IOException e) {
            throw new SecurityException(i18n.getLocalMessage("i18n.mityc.trust.utils.2"), e);
        }
    }

    public static byte[] recoverConf(String filePath) throws SecurityException {
        byte[] byArray;
        if (pass == null || "".equals(new String(pass).trim()) || !new File(filePath).exists()) {
            throw new SecurityException(i18n.getLocalMessage("i18n.mityc.trust.utils.1"));
        }
        InputStream bis = null;
        try {
            File file = new File(filePath);
            bis = new BufferedInputStream(new FileInputStream(file));
            byte[] buffer = null;
            int length = 0;
            int numBytes = 0;
            long len = file.length();
            if (len > Integer.MAX_VALUE) {
                throw new SecurityException("Fichero de configuraci\u00f3n demasiado largo: " + len);
            }
            buffer = new byte[(int)file.length()];
            if (buffer.length < 4096) {
                bis.read(buffer, length, (int)file.length());
            } else {
                int longitud = bis.read(buffer, length, 4096);
                while ((numBytes = longitud) >= 0) {
                    longitud = bis.read(buffer, length += numBytes, 4096);
                }
            }
            if (len < 4L) {
                byte[] byArray2 = buffer;
                return byArray2;
            }
            TripleDESManager p = new TripleDESManager();
            byArray = p.recoverTripleDES(new String(buffer).toCharArray(), new String(pass));
        }
        catch (IOException ex) {
            throw new SecurityException(ex);
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Exception exception) {}
        }
        return byArray;
    }
}

