/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.trust;

import es.mityc.javasign.trust.ITrustCRLEmisor;
import es.mityc.javasign.trust.ITrustOCSPProducer;
import es.mityc.javasign.trust.ITrustSignCerts;
import es.mityc.javasign.trust.ITrustTSProducer;
import es.mityc.javasign.trust.TrustAbstract;
import es.mityc.javasign.trust.TrustException;
import es.mityc.javasign.trust.UnknownTrustException;
import java.security.cert.CertPath;
import java.security.cert.X509CRL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.ocsp.OCSPResp;
import org.bouncycastle.tsp.TimeStampToken;

public abstract class TrustAdapter
extends TrustAbstract
implements ITrustCRLEmisor,
ITrustOCSPProducer,
ITrustSignCerts,
ITrustTSProducer {
    private static Log logger = LogFactory.getLog(TrustAdapter.class);

    public void isTrusted(Object data) throws TrustException {
        if (data instanceof CertPath) {
            this.isTrusted((CertPath)data);
        } else if (data instanceof TimeStampToken) {
            this.isTrusted((TimeStampToken)data);
        } else if (data instanceof X509CRL) {
            this.isTrusted((X509CRL)data);
        } else if (data instanceof OCSPResp) {
            this.isTrusted((OCSPResp)data);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No se pudo validar la confianza porque no se reconoce el tipo indicado: " + (data != null ? data.getClass() : "Tipo nulo")));
            }
            throw new UnknownTrustException();
        }
    }
}

