/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.trust;

import es.mityc.javasign.trust.ITrustServices;
import es.mityc.javasign.trust.PropsTruster;
import es.mityc.javasign.trust.TrustException;
import es.mityc.javasign.trust.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MyPropsTruster
extends PropsTruster
implements ITrustServices {
    static Log log = LogFactory.getLog(MyPropsTruster.class);
    private static final String CONF_FILE = "trust/myTruster.properties";

    protected MyPropsTruster(InputStream externalConf) {
        super(CONF_FILE, externalConf);
    }

    public static synchronized MyPropsTruster getInstance(InputStream externalConf) {
        if (instance == null) {
            instance = new MyPropsTruster(externalConf);
        }
        return (MyPropsTruster)instance;
    }

    private synchronized void reloadConf() {
        this.loadConf(CONF_FILE, this.externalProps);
    }

    @Override
    public void addCA(X509Certificate cert, PropsTruster.TrusterType type, String path) throws TrustException {
        String fileName = null;
        List<TrustCertStruct> cas = this.getCAs();
        int i = 0;
        while (i < cas.size()) {
            if (cert.equals(cas.get(i).getCert())) {
                return;
            }
            ++i;
        }
        try {
            fileName = Utils.getMD5(cert);
        }
        catch (Exception e) {
            throw new TrustException((Throwable)e);
        }
        String pathToCert = String.valueOf(path) + File.separator + "CAs";
        File desFile = new File(pathToCert);
        if (!desFile.exists()) {
            desFile.mkdirs();
        }
        if (!new File(pathToCert = String.valueOf(path) + File.separator + "CAs" + File.separator + fileName + ".cer").exists()) {
            FileOutputStream fos = null;
            try {
                try {
                    fos = new FileOutputStream(pathToCert);
                    fos.write(cert.getEncoded());
                }
                catch (IOException e) {
                    throw new TrustException((Throwable)e);
                }
                catch (CertificateEncodingException e) {
                    throw new TrustException((Throwable)e);
                }
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        throw new TrustException((Throwable)e);
                    }
                }
            }
        }
        String key = String.valueOf(type.toString()) + '.' + fileName;
        int i2 = 2;
        while (this.externalProps.containsKey(key)) {
            key = String.valueOf(type.toString()) + '.' + fileName + i2;
            ++i2;
        }
        this.externalProps.setProperty(key, pathToCert);
        this.reloadConf();
    }

    @Override
    public boolean containsCert(String md5Digest) throws TrustException {
        if (this.externalProps == null) {
            throw new TrustException("No hay propiedades externas cargadas");
        }
        boolean result = false;
        Enumeration<Object> keys = this.externalProps.keys();
        String key = null;
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            if (!key.contains(md5Digest)) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public void removeCA(X509Certificate cert, PropsTruster.TrusterType type, String path) throws TrustException {
        String fileName = null;
        try {
            fileName = Utils.getMD5(cert);
        }
        catch (Exception e) {
            throw new TrustException((Throwable)e);
        }
        String pathToCert = String.valueOf(path) + "CAs";
        File desFile = new File(pathToCert);
        if (!desFile.exists()) {
            throw new TrustException("No se encuentra el repositorio de certificados local");
        }
        pathToCert = String.valueOf(pathToCert) + File.separator + fileName + ".cer";
        String keyToDel = String.valueOf(type.toString()) + '.' + fileName;
        boolean isDeleted = false;
        if (this.externalProps.containsKey(keyToDel)) {
            Enumeration<Object> keys = this.externalProps.keys();
            String key = null;
            while (keys.hasMoreElements()) {
                key = (String)keys.nextElement();
                if (!key.contains(keyToDel)) continue;
                this.externalProps.remove(key);
                isDeleted = true;
                break;
            }
            if (!isDeleted) {
                throw new TrustException("Error al borrar. No se pudo borrar el certificado " + keyToDel);
            }
        } else {
            throw new TrustException("Error al borrar. No se encuentra el certificado " + keyToDel);
        }
        this.reloadConf();
        desFile = new File(pathToCert);
        if (!desFile.exists()) {
            throw new TrustException("Error al borrar. No se encuentra el certificado indicado");
        }
        if (!desFile.delete()) {
            log.error((Object)("No se pudo borrar el certificado indicado: " + pathToCert));
            desFile.deleteOnExit();
        }
    }

    @Override
    public List<TrustCertStruct> getCAs() throws TrustException {
        ArrayList<TrustCertStruct> cas = new ArrayList<TrustCertStruct>();
        Iterator<X509Certificate> internalCAs = this.getTrustedCAs(PropsTruster.TrusterType.TRUSTER_SIGNCERTS_CERTS).iterator();
        while (internalCAs.hasNext()) {
            cas.add(new TrustCertStruct(internalCAs.next(), PropsTruster.TrusterType.TRUSTER_SIGNCERTS_CERTS, true));
        }
        internalCAs = this.getTrustedCAs(PropsTruster.TrusterType.TRUSTER_SIGNCERTS_ISSUER).iterator();
        while (internalCAs.hasNext()) {
            cas.add(new TrustCertStruct(internalCAs.next(), PropsTruster.TrusterType.TRUSTER_SIGNCERTS_ISSUER, true));
        }
        internalCAs = this.getTrustedCAs(PropsTruster.TrusterType.TRUSTER_OCSP_CERTS).iterator();
        while (internalCAs.hasNext()) {
            cas.add(new TrustCertStruct(internalCAs.next(), PropsTruster.TrusterType.TRUSTER_OCSP_CERTS, true));
        }
        internalCAs = this.getTrustedCAs(PropsTruster.TrusterType.TRUSTER_OCSP_ISSUER).iterator();
        while (internalCAs.hasNext()) {
            cas.add(new TrustCertStruct(internalCAs.next(), PropsTruster.TrusterType.TRUSTER_OCSP_ISSUER, true));
        }
        internalCAs = this.getTrustedCAs(PropsTruster.TrusterType.TRUSTER_TSA_CERTS).iterator();
        while (internalCAs.hasNext()) {
            cas.add(new TrustCertStruct(internalCAs.next(), PropsTruster.TrusterType.TRUSTER_TSA_CERTS, true));
        }
        internalCAs = this.getTrustedCAs(PropsTruster.TrusterType.TRUSTER_TSA_ISSUER).iterator();
        while (internalCAs.hasNext()) {
            cas.add(new TrustCertStruct(internalCAs.next(), PropsTruster.TrusterType.TRUSTER_TSA_ISSUER, true));
        }
        internalCAs = this.getTrustedCAs(PropsTruster.TrusterType.TRUSTER_CRL_ISSUER).iterator();
        while (internalCAs.hasNext()) {
            cas.add(new TrustCertStruct(internalCAs.next(), PropsTruster.TrusterType.TRUSTER_CRL_ISSUER, true));
        }
        if (this.externalProps == null || this.externalProps.size() <= 0) {
            return cas;
        }
        Enumeration<Object> keys = this.externalProps.keys();
        String key = null;
        CertificateFactory cf = null;
        try {
            cf = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new TrustException("Error al listar. No se pueden instanciar certificados X509", (Throwable)e);
        }
        FileInputStream fis = null;
        TrustCertStruct tc = null;
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            try {
                tc = new TrustCertStruct();
                tc.setInternal(false);
                fis = new FileInputStream(new File(this.externalProps.getProperty(key)));
                X509Certificate cert = (X509Certificate)cf.generateCertificate(fis);
                if (!this.checkCert(key, cert)) {
                    throw new TrustException("Certificado alterado: " + key);
                }
                tc.setCert(cert);
                if (key.contains(PropsTruster.TrusterType.TRUSTER_SIGNCERTS_CERTS.toString())) {
                    tc.setType(PropsTruster.TrusterType.TRUSTER_SIGNCERTS_CERTS);
                } else if (key.contains(PropsTruster.TrusterType.TRUSTER_SIGNCERTS_ISSUER.toString())) {
                    tc.setType(PropsTruster.TrusterType.TRUSTER_SIGNCERTS_ISSUER);
                } else if (key.contains(PropsTruster.TrusterType.TRUSTER_OCSP_CERTS.toString())) {
                    tc.setType(PropsTruster.TrusterType.TRUSTER_OCSP_CERTS);
                } else if (key.contains(PropsTruster.TrusterType.TRUSTER_OCSP_ISSUER.toString())) {
                    tc.setType(PropsTruster.TrusterType.TRUSTER_OCSP_ISSUER);
                } else if (key.contains(PropsTruster.TrusterType.TRUSTER_CRL_ISSUER.toString())) {
                    tc.setType(PropsTruster.TrusterType.TRUSTER_CRL_ISSUER);
                } else if (key.contains(PropsTruster.TrusterType.TRUSTER_TSA_CERTS.toString())) {
                    tc.setType(PropsTruster.TrusterType.TRUSTER_TSA_CERTS);
                } else if (key.contains(PropsTruster.TrusterType.TRUSTER_TSA_ISSUER.toString())) {
                    tc.setType(PropsTruster.TrusterType.TRUSTER_TSA_ISSUER);
                } else {
                    tc.setType(PropsTruster.TrusterType.TRUSTER_SIGNCERTS_CERTS);
                }
                boolean alreadyInList = false;
                int i = 0;
                while (i < cas.size()) {
                    if (cas.get(i).getCert().equals(tc.getCert())) {
                        tc.setInternal(false);
                        cas.remove(i);
                        cas.add(i, tc);
                        alreadyInList = true;
                        break;
                    }
                    ++i;
                }
                if (!alreadyInList) {
                    cas.add(tc);
                }
            }
            catch (CertificateException e) {
                log.error((Object)("Error al listar. No se pudo leer el certificado " + this.externalProps.getProperty(key)), (Throwable)e);
                if (fis == null) continue;
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
                continue;
            }
            catch (FileNotFoundException e) {
                try {
                    log.error((Object)("Error al listar. No se pudo encontrar el certificado " + this.externalProps.getProperty(key)), (Throwable)e);
                    continue;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            if (fis == null) continue;
            try {
                fis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return cas;
    }

    public Properties getActualProperties() {
        return this.externalProps;
    }

    private boolean checkCert(String key, X509Certificate cert) throws TrustException {
        try {
            String fileName = Utils.getMD5(cert);
            return fileName == null ? false : key.contains(fileName);
        }
        catch (Exception e) {
            throw new TrustException((Throwable)e);
        }
    }

    public class TrustCertStruct {
        private X509Certificate cert = null;
        private PropsTruster.TrusterType type = null;
        private boolean isInternal = false;

        public TrustCertStruct() {
            new TrustCertStruct(null, null, false);
        }

        public TrustCertStruct(X509Certificate cert, PropsTruster.TrusterType type, boolean isInternal) {
            this.cert = cert;
            this.type = type;
            this.isInternal = isInternal;
        }

        public X509Certificate getCert() {
            return this.cert;
        }

        public synchronized void setCert(X509Certificate cert) {
            this.cert = cert;
        }

        public PropsTruster.TrusterType getType() {
            return this.type;
        }

        public synchronized void setType(PropsTruster.TrusterType type) {
            this.type = type;
        }

        public boolean isInternal() {
            return this.isInternal;
        }

        public void setInternal(boolean isInternal) {
            this.isInternal = isInternal;
        }
    }
}

