/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.xml.xades.policy;

import es.mityc.firmaJava.libreria.xades.DatosFirma;
import es.mityc.firmaJava.libreria.xades.ResultadoValidacion;
import es.mityc.firmaJava.libreria.xades.errores.PolicyException;
import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.trust.TrustAbstract;
import es.mityc.javasign.trust.TrustException;
import es.mityc.javasign.trust.TrustFactory;
import es.mityc.javasign.xml.xades.policy.IValidacionPolicy;
import es.mityc.javasign.xml.xades.policy.PolicyResult;
import java.net.URI;
import java.net.URISyntaxException;
import org.w3c.dom.Element;

public class MITyCTrustPolicy
implements IValidacionPolicy {
    private static final II18nManager I18N = I18nFactory.getI18nManager((String)"MITyCLibPolicy");
    private static final String POLICY_URI = "self:policy/mityc/trust";
    protected TrustAbstract truster = TrustFactory.getInstance().getTruster("mityc");

    public MITyCTrustPolicy() throws InstantiationException {
        if (this.truster == null) {
            throw new InstantiationException(I18N.getLocalMessage("i18n.mityc.policy.mityc.1"));
        }
    }

    public String getIdentidadPolicy() {
        return I18N.getLocalMessage("i18n.mityc.policy.mityc.2");
    }

    public PolicyResult validaPolicy(Element nodoFirma, ResultadoValidacion resultadoValidacion) {
        PolicyResult pr = new PolicyResult();
        try {
            pr.setPolicyID(new URI(POLICY_URI));
            this.checkTrustSigningCertificate(nodoFirma, resultadoValidacion);
            pr.setResult(PolicyResult.StatusValidation.valid);
        }
        catch (PolicyException ex) {
            pr.setResult(PolicyResult.StatusValidation.invalid);
            pr.setDescriptionResult(ex.getMessage());
        }
        catch (URISyntaxException ex) {
            pr.setResult(PolicyResult.StatusValidation.unknown);
            pr.setDescriptionResult(ex.getMessage());
        }
        return pr;
    }

    protected void checkTrustSigningCertificate(Element signatureNode, ResultadoValidacion rs) throws PolicyException {
        DatosFirma df = rs.getDatosFirma();
        if (df != null) {
            try {
                this.truster.isTrusted((Object)df.getCadenaFirma());
            }
            catch (TrustException ex) {
                throw new PolicyException(I18N.getLocalMessage("i18n.mityc.policy.mityc.3"));
            }
        } else {
            throw new PolicyException(I18N.getLocalMessage("i18n.mityc.policy.mityc.4"));
        }
    }

    public void setTruster(TrustAbstract truster) {
        this.truster = truster;
    }
}

