/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.crypto.symetric;

import es.mityc.crypto.CryptoManager;
import es.mityc.crypto.Utils;
import es.mityc.crypto.symetric.DESCipherManager;
import es.mityc.javasign.utils.Base64Coder;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AESCipherManager
implements CryptoManager {
    static Log logger = LogFactory.getLog(AESCipherManager.class);
    private byte[] salt = null;
    private int iter = 0;
    private Cipher aesCipher = null;
    private SecretKeyFactory skfAes = null;

    public AESCipherManager() {
        this.init(null, 0);
    }

    public AESCipherManager(byte[] salt, int iter) {
        this.init(salt, iter);
    }

    @Override
    public void feedSeed(byte[] seed) {
        if (seed == null) {
            seed = SecureRandom.getSeed(8);
        }
        int i = 0;
        while (i < this.salt.length && i < seed.length) {
            this.salt[i] = (byte)(this.salt[i] & seed[i]);
            ++i;
        }
    }

    private void init(byte[] salt, int iter) {
        if (salt != null) {
            this.feedSeed(salt);
        } else {
            this.salt = SecureRandom.getSeed(8);
        }
        this.iter = iter != 0 ? iter : 256;
        if (Security.getProvider("BC") == null) {
            es.mityc.javasign.utils.Utils.addBCProvider();
        }
        try {
            this.aesCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            this.skfAes = SecretKeyFactory.getInstance("PBEWithSHA256And256BitAES-CBC-BC", "BC");
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public char[] protectAES(String plain, String password) throws SecurityException {
        if (password == null || "".equals(new String(password).trim()) || plain == null) {
            throw new SecurityException("Faltan par\u00e1metros de entrada");
        }
        return this.protectAES(plain.getBytes(), password);
    }

    public char[] protectAES(byte[] plain, String password) throws SecurityException {
        if (password == null || "".equals(new String(password).trim()) || plain == null) {
            throw new SecurityException("Faltan par\u00e1metros de entrada");
        }
        if (password.length() < 8) {
            logger.warn((Object)"La clave debe tener al menos 8 bytes. Se emplea su valor SHA1 como contrase\u00f1a.");
            try {
                MessageDigest hash = MessageDigest.getInstance("SHA1", "BC");
                password = new String(hash.digest(password.getBytes()));
            }
            catch (NoSuchAlgorithmException e) {
                throw new SecurityException("Error al calcular el Digest de la contrase\u00f1a", e);
            }
            catch (NoSuchProviderException e) {
                throw new SecurityException("Error al calcular el Digest de la contrase\u00f1a", e);
            }
        }
        try {
            SecretKey pbeKey = this.skfAes.generateSecret(new PBEKeySpec(password.toCharArray(), this.salt, this.iter));
            SecretKeySpec secret = new SecretKeySpec(pbeKey.getEncoded(), "AES");
            this.aesCipher.init(1, secret);
            byte[] ciphertext = this.aesCipher.doFinal(plain);
            return Base64Coder.encode((byte[])ciphertext);
        }
        catch (InvalidKeySpecException ex) {
            throw new SecurityException(ex);
        }
        catch (InvalidKeyException ex) {
            throw new SecurityException(ex);
        }
        catch (IllegalBlockSizeException ex) {
            throw new SecurityException(ex);
        }
        catch (BadPaddingException ex) {
            throw new SecurityException(ex);
        }
    }

    public byte[] recoverAES(char[] cryptedText, String password) throws SecurityException {
        if (password == null || "".equals(new String(password).trim()) || cryptedText == null) {
            throw new SecurityException("Faltan par\u00e1metros de entrada");
        }
        if (password.length() < 8) {
            logger.warn((Object)"La clave debe tener al menos 8 bytes. Se emplea su valor SHA1 como contrase\u00f1a.");
            try {
                MessageDigest hash = MessageDigest.getInstance("SHA1", "BC");
                password = new String(hash.digest(password.getBytes()));
            }
            catch (NoSuchAlgorithmException e) {
                throw new SecurityException("Error al calcular el Digest de la contrase\u00f1a", e);
            }
            catch (NoSuchProviderException e) {
                throw new SecurityException("Error al calcular el Digest de la contrase\u00f1a", e);
            }
        }
        try {
            PBEParameterSpec pbeParamSpec = new PBEParameterSpec(this.salt, this.iter);
            SecretKey pbeKey = this.skfAes.generateSecret(new PBEKeySpec(password.toCharArray()));
            this.aesCipher.init(2, (Key)pbeKey, pbeParamSpec);
            byte[] ciphertext = this.aesCipher.doFinal(Base64Coder.decode((Object)cryptedText));
            return ciphertext;
        }
        catch (InvalidKeySpecException ex) {
            throw new SecurityException(ex);
        }
        catch (InvalidKeyException ex) {
            throw new SecurityException(ex);
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new SecurityException(ex);
        }
        catch (IllegalBlockSizeException ex) {
            throw new SecurityException(ex);
        }
        catch (BadPaddingException ex) {
            throw new SecurityException("Contrase\u00f1a incorrecta", ex);
        }
    }

    @Override
    public String getUsedAlgorithmURI() {
        return "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
    }

    public static void main(String[] args) {
        String plain = "TextoEnClaro0123456789";
        String pass = "1234567890123456789012345678901234567890";
        DESCipherManager p = new DESCipherManager();
        System.out.println("Texto en claro: " + plain);
        String buffer = Utils.obfuscate(plain);
        System.out.println("Texto ofuscado: " + buffer);
        buffer = Utils.undoObfuscate(buffer.getBytes());
        System.out.println("Texto recuperado: " + buffer);
        char[] bufferChar = p.protectPBEandDES(buffer, pass);
        buffer = new String(bufferChar);
        System.out.println("Texto encriptado AES: " + buffer);
        buffer = new String(p.recoverPBEandDES(bufferChar, pass));
        System.out.println("Texto desencriptado AES: " + buffer);
        Long start = System.currentTimeMillis();
        buffer = Utils.obfuscate(new String(p.protectPBEandDES(buffer, pass)));
        System.out.println("Encriptado AES y ofuscado: " + buffer);
        buffer = new String(p.recoverPBEandDES(Utils.undoObfuscate(buffer.getBytes()).toCharArray(), pass));
        Long time = System.currentTimeMillis() - start;
        System.out.println("Texto recuperado: " + buffer + "\nTiempo consumido (ms): " + time);
    }
}

