/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.crypto.steganography;

import es.mityc.crypto.steganography.StegoData;
import es.mityc.crypto.steganography.StegoException;
import es.mityc.crypto.steganography.StegoUtils;
import es.mityc.crypto.symetric.TripleDESManager;
import es.mityc.javasign.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StegoManager {
    static Log logger = LogFactory.getLog(StegoManager.class);
    private StegoData sd = new StegoData();

    public byte[] ocultarInfo(File msgFile, File coverFile) throws StegoException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Insertando datos en " + coverFile));
        }
        FileInputStream is = null;
        if (msgFile == null || !msgFile.exists()) {
            throw new StegoException(new Exception("La imagen indicada: " + msgFile.getAbsolutePath() + " no existe."));
        }
        if (coverFile == null || !coverFile.exists()) {
            throw new StegoException(new Exception("El fichero indicado: " + coverFile.getAbsolutePath() + " no existe."));
        }
        try {
            if (msgFile != null) {
                is = new FileInputStream(msgFile);
            }
            return this.ocultarInfo(Utils.getStreamBytes(is), msgFile.getName(), coverFile == null ? null : Utils.getFileBytes((File)coverFile), coverFile == null ? null : coverFile.getAbsolutePath());
        }
        catch (StegoException soEx) {
            throw soEx;
        }
        catch (Exception ioEx) {
            logger.error((Object)ioEx);
            return null;
        }
    }

    public byte[] ocultarInfo(byte[] datos, String msgFileName, byte[] imagen, String imagenFileFormat) throws StegoException {
        try {
            block8: {
                if (this.sd.config.isComprimir()) {
                    try {
                        datos = StegoUtils.zipData(datos);
                    }
                    catch (Exception e) {
                        if (!logger.isDebugEnabled()) break block8;
                        logger.debug((Object)"Se contin\u00faa sin comprimir");
                    }
                }
            }
            if (this.sd.config.isEncriptar()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Encriptando " + datos.length + " bytes"));
                }
                TripleDESManager crypto = new TripleDESManager();
                datos = new String(crypto.protectTripleDES(datos, this.sd.config.getPassword())).getBytes();
            }
            return this.sd.embeberDatos(datos, msgFileName, imagen, imagenFileFormat, this.sd.config.getPassword());
        }
        catch (StegoException osEx) {
            logger.error((Object)osEx);
            throw osEx;
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            return null;
        }
    }

    public List<Object> extraerDatos(byte[] stegoData) {
        byte[] msg = null;
        ArrayList<Object> output = new ArrayList<Object>();
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Extrayendo datos: ");
            }
            msg = this.sd.extraerDatos(stegoData, this.sd.config.getPassword());
            output.add(this.sd.getStegoFileName());
            if (this.sd.config.isEncriptar()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Desencriptando " + msg.length + " bytes"));
                }
                TripleDESManager crypto = new TripleDESManager();
                msg = crypto.recoverTripleDES(new String(msg).toCharArray(), this.sd.config.getPassword());
            }
            if (this.sd.config.isComprimir()) {
                try {
                    msg = StegoUtils.unzipData(msg);
                }
                catch (IOException ioEx) {
                    logger.error((Object)"No se inflaron los datos");
                }
            }
            output.add(msg);
        }
        catch (StegoException osEx) {
            logger.debug((Object)osEx);
        }
        catch (IndexOutOfBoundsException ex) {
            if (msg.length == 0) {
                logger.warn((Object)"La imagen no contiene datos");
            } else {
                logger.error((Object)ex);
            }
        }
        catch (Exception ex) {
            logger.debug((Object)ex);
        }
        return output;
    }

    public List<Object> extraerDatos(File stegoFile) throws IOException {
        return this.extraerDatos(Utils.getFileBytes((File)stegoFile));
    }

    public void setPassword(String password) {
        this.sd.config.setEncriptar(true);
        this.sd.config.setPassword(password);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Contrase\u00f1a establecida");
        }
    }

    public void setComprimir(boolean f) {
        this.sd.config.setComprimir(f);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Uso de compresi\u00f3n: " + f));
        }
    }

    public static void main(String[] args) {
        StegoManager ssg = new StegoManager();
        ssg.setPassword("Caracola");
        ssg.setComprimir(true);
        try {
            byte[] stego = ssg.ocultarInfo(new File("resources/DocumentoA.pdf"), new File("resources/imagen.png"));
            Utils.writeFile((byte[])stego, (String)"./Steganografriado.png");
            List<Object> lista = ssg.extraerDatos(new File("./Steganografriado.png"));
            Utils.writeFile((byte[])((byte[])lista.get(1)), (String)new String((byte[])lista.get(0)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (StegoException e) {
            e.printStackTrace();
        }
    }
}

