/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.crypto.asymetric;

import es.mityc.crypto.CryptoManager;
import es.mityc.crypto.Utils;
import es.mityc.crypto.symetric.TripleDESManager;
import es.mityc.javasign.pkstore.IPKStoreManager;
import es.mityc.javasign.utils.Base64Coder;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RSAManager
implements CryptoManager {
    static Log logger = LogFactory.getLog(RSAManager.class);
    private static final int keySize = 1024;
    private static final byte[] salt = SecureRandom.getSeed(8);
    private Cipher rsaCipher = null;
    private SecureRandom random = null;
    private TripleDESManager simetricCipher = null;
    public static final String RSA_OAEP_KEY = "RSA/None/OAEPWithSHA1AndMGF1Padding";
    public static final String RSA_NONE = "RSA/None/NoPadding";
    public static final String RSA_ECB_PKCS1 = "RSA/ECB/PKCS1Padding";
    public static final String RSA = "RSA";
    private String usedAlgorithm = "RSA/None/OAEPWithSHA1AndMGF1Padding";

    public RSAManager() {
        this.init();
    }

    @Override
    public void feedSeed(byte[] seed) {
        this.random.nextBytes(salt);
        if (seed != null) {
            int i = 0;
            while (i < salt.length && i < seed.length) {
                RSAManager.salt[i] = (byte)(salt[i] & seed[i]);
                ++i;
            }
        }
        this.random.setSeed(salt);
    }

    private void init() throws SecurityException {
        if (Security.getProvider("BC") == null) {
            es.mityc.javasign.utils.Utils.addBCProvider();
        }
        try {
            this.rsaCipher = Cipher.getInstance(RSA_OAEP_KEY, "BC");
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityException("No se pudo instanciar el algoritmo RSA", e);
        }
        catch (NoSuchProviderException e) {
            throw new SecurityException("No se encontr\u00f3 el proveedor de BouncyCastle", e);
        }
        catch (NoSuchPaddingException e) {
            throw new SecurityException("No se pudo inicializar el relleno", e);
        }
        this.random = new SecureRandom(salt);
    }

    public char[] protectRSA(String plain, Key key) throws SecurityException {
        return this.protectRSA(plain.getBytes(), key);
    }

    public char[] protectRSA(String plain, Key key, Provider provider) throws SecurityException {
        return this.protectRSA(plain.getBytes(), key, provider);
    }

    public char[] protectRSA(byte[] plain, Key key) throws SecurityException {
        if (key == null || plain == null) {
            throw new SecurityException("Faltan par\u00e1metros de entrada");
        }
        try {
            this.rsaCipher.init(1, key, this.random);
            byte[] cipherText = this.rsaCipher.doFinal(plain);
            return Base64Coder.encode((byte[])cipherText);
        }
        catch (InvalidKeyException ex) {
            throw new SecurityException(ex);
        }
        catch (IllegalBlockSizeException ex) {
            throw new SecurityException(ex);
        }
        catch (BadPaddingException ex) {
            throw new SecurityException(ex);
        }
    }

    public char[] protectRSA(byte[] plain, Key key, String alg) throws SecurityException {
        return this.protectRSA(plain, key, alg, null);
    }

    public char[] protectRSA(byte[] plain, Key key, String alg, Provider provider) throws SecurityException {
        if (key == null || plain == null) {
            throw new SecurityException("Faltan par\u00e1metros de entrada");
        }
        if (provider == null) {
            provider = Security.getProvider("BC");
        }
        Cipher cipher = null;
        try {
            this.usedAlgorithm = alg;
            cipher = Cipher.getInstance(this.usedAlgorithm, provider.getName());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Empleando el algoritmo " + this.usedAlgorithm + " con el proveedor " + cipher.getProvider().getName()));
            }
            cipher.init(1, key, this.random);
            byte[] cipherText = cipher.doFinal(plain);
            char[] cArray = Base64Coder.encode((byte[])cipherText);
            return cArray;
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
        finally {
            if (Security.getProvider("BC") != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Eliminando el proveedor BC");
                }
                Security.removeProvider("BC");
            }
        }
    }

    public char[] protectRSA(byte[] plain, Key key, Provider provider) throws SecurityException {
        if (key == null || plain == null) {
            throw new SecurityException("Faltan par\u00e1metros de entrada");
        }
        Cipher cipher = null;
        this.usedAlgorithm = RSA_OAEP_KEY;
        try {
            if (provider != null) {
                Provider.Service s = provider.getService("Cipher", this.usedAlgorithm);
                if (s == null) {
                    logger.error((Object)("No se pudo encontrar el servicio Cipher.RSA en " + provider.getName()));
                    this.usedAlgorithm = RSA;
                    if (logger.isTraceEnabled() && provider.getServices() != null) {
                        logger.trace((Object)"Servicios disponibles --> ");
                        Object[] ser = provider.getServices().toArray();
                        int i = 0;
                        while (i < ser.length) {
                            logger.trace((Object)("Algoritmo disponible: " + ((Provider.Service)ser[i]).getAlgorithm()));
                            ++i;
                        }
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Proveedor: " + provider.getInfo()));
                    logger.debug((Object)("Algoritmo a emplear: " + this.usedAlgorithm));
                }
                cipher = Cipher.getInstance(this.usedAlgorithm, provider);
            } else {
                cipher = Cipher.getInstance(this.usedAlgorithm);
            }
            cipher.init(1, key, this.random);
            byte[] cipherText = cipher.doFinal(plain);
            char[] cArray = Base64Coder.encode((byte[])cipherText);
            return cArray;
        }
        catch (InvalidKeyException ex) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.error((Object)ex);
                    logger.debug((Object)"Reintento con configuraci\u00f3n por defecto: ");
                }
                this.usedAlgorithm = RSA_ECB_PKCS1;
                cipher = Cipher.getInstance(this.usedAlgorithm, "BC");
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Empleando el algoritmo " + this.usedAlgorithm + " con el proveedor " + cipher.getProvider().getName()));
                }
                cipher.init(1, key, this.random);
                byte[] cipherText = cipher.doFinal(plain);
                char[] cArray = Base64Coder.encode((byte[])cipherText);
                return cArray;
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Error al encriptar", (Throwable)e);
                }
                throw new SecurityException(ex);
            }
        }
        catch (IllegalBlockSizeException ex) {
            throw new SecurityException(ex);
        }
        catch (BadPaddingException ex) {
            throw new SecurityException(ex);
        }
        catch (NoSuchAlgorithmException e) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.error((Object)e);
                    logger.debug((Object)"NoSuchAlgorithmException. Reintento con configuraci\u00f3n por defecto: ");
                }
                this.usedAlgorithm = RSA_ECB_PKCS1;
                cipher = Cipher.getInstance(this.usedAlgorithm, "BC");
                cipher.init(1, key, this.random);
                byte[] cipherText = cipher.doFinal(plain);
                char[] cArray = Base64Coder.encode((byte[])cipherText);
                return cArray;
            }
            catch (Exception e2) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"No se encontr\u00f3 el algoritmo", (Throwable)e2);
                }
                throw new SecurityException("No se detect\u00f3 el algoritmo RSA", e);
            }
        }
        catch (NoSuchPaddingException e) {
            throw new SecurityException(e);
        }
        finally {
            if (provider != null && Security.getProvider(provider.getName()) != null) {
                Security.removeProvider(provider.getName());
            }
        }
    }

    public byte[] recoverRSA(char[] cryptedText, Key key) throws SecurityException {
        if (key == null || cryptedText == null) {
            throw new SecurityException("Faltan par\u00e1metros de entrada");
        }
        try {
            this.rsaCipher.init(2, key);
            byte[] ciphertext = this.rsaCipher.doFinal(Base64Coder.decode((Object)cryptedText));
            return ciphertext;
        }
        catch (InvalidKeyException ex) {
            throw new SecurityException(ex);
        }
        catch (IllegalBlockSizeException ex) {
            throw new SecurityException(ex);
        }
        catch (BadPaddingException ex) {
            throw new SecurityException("Clave incorrecta", ex);
        }
        catch (IllegalArgumentException ex) {
            throw new SecurityException("Clave incorrecta", ex);
        }
    }

    public byte[] recoverRSA(char[] cryptedText, IPKStoreManager storeManager, X509Certificate cert, String algoritmURI) throws SecurityException {
        return this.recoverRSA(cryptedText, storeManager, cert, algoritmURI, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] recoverRSA(char[] cryptedText, IPKStoreManager storeManager, X509Certificate cert, String algoritmURI, Provider provider) throws SecurityException {
        if (storeManager == null) throw new SecurityException("Faltan par\u00e1metros de entrada");
        if (cryptedText == null) throw new SecurityException("Faltan par\u00e1metros de entrada");
        if (cert == null) {
            throw new SecurityException("Faltan par\u00e1metros de entrada");
        }
        if (provider == null) {
            provider = Security.getProvider("BC");
        }
        PrivateKey privateKey = null;
        try {
            if (provider != null && Security.getProvider(provider.getName()) == null) {
                Security.addProvider(provider);
                if (logger.isDebugEnabled()) {
                    if (Security.getProvider(provider.getName()) == null) {
                        logger.debug((Object)"No se ha insertado el proveedor");
                    } else {
                        logger.debug((Object)"Proveedor insertado correctamente");
                    }
                }
            }
            privateKey = storeManager.getPrivateKey(cert);
            if (logger.isTraceEnabled()) {
                Provider[] provs = Security.getProviders();
                if (provs != null) {
                    logger.trace((Object)"\n*** Proveedores disponibles --> ");
                    int i = 0;
                    while (i < provs.length) {
                        logger.trace((Object)provs[i].getName());
                        ++i;
                    }
                }
                if (provider != null && provider.getServices() != null) {
                    logger.trace((Object)("\n*** Servicios disponibles en " + provider.getName() + " --> "));
                    Object[] ser = provider.getServices().toArray();
                    int i = 0;
                    while (i < ser.length) {
                        logger.trace((Object)((Provider.Service)ser[i]).getAlgorithm());
                        ++i;
                    }
                }
                if (privateKey != null) {
                    logger.trace((Object)("Algoritmo de la clave privada --> " + privateKey.getAlgorithm()));
                    logger.trace((Object)("Formato de la clave privada --> " + privateKey.getFormat()));
                }
            }
            this.usedAlgorithm = algoritmURI != null ? algoritmURI : RSA_OAEP_KEY;
            Cipher cipher = null;
            if (provider != null) {
                cipher = Cipher.getInstance(this.usedAlgorithm, provider);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Empleando el algoritmo " + this.usedAlgorithm + " con el proveedor " + provider));
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Empleando el algoritmo " + this.usedAlgorithm + " con la lista de proveedores"));
                }
                cipher = Cipher.getInstance(this.usedAlgorithm);
            }
            byte[] ciphertext = null;
            return this.decryptText(cryptedText, provider, privateKey, cipher);
        }
        catch (Exception ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Se produjo un error al desencriptar: " + ex.getMessage()), (Throwable)ex);
            }
            try {
                byte[] ciphertext;
                this.usedAlgorithm = RSA_OAEP_KEY;
                Cipher cipher = Cipher.getInstance(this.usedAlgorithm);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Empleando el algoritmo " + this.usedAlgorithm + " con el proveedor " + cipher.getProvider().getName()));
                }
                byte[] byArray = ciphertext = this.decryptText(cryptedText, provider, privateKey, cipher);
                return byArray;
            }
            catch (Exception e2) {
                logger.debug((Object)("Error RSA para el descifrado seg\u00fan: " + this.usedAlgorithm), (Throwable)e2);
                try {
                    byte[] ciphertext;
                    this.usedAlgorithm = RSA_ECB_PKCS1;
                    Cipher cipher = Cipher.getInstance(this.usedAlgorithm, provider);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Empleando el algoritmo " + this.usedAlgorithm + " con el proveedor " + cipher.getProvider().getName()));
                    }
                    byte[] byArray = ciphertext = this.decryptText(cryptedText, provider, privateKey, cipher);
                    return byArray;
                }
                catch (Exception e3) {
                    logger.debug((Object)("Error RSA para el descifrado seg\u00fan: " + this.usedAlgorithm + " con el proveedor " + provider), (Throwable)e3);
                    try {
                        byte[] ciphertext;
                        this.usedAlgorithm = RSA;
                        Cipher cipher = Cipher.getInstance(this.usedAlgorithm, provider);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Empleando el algoritmo " + this.usedAlgorithm + " con el proveedor " + cipher.getProvider().getName()));
                        }
                        byte[] byArray = ciphertext = this.decryptText(cryptedText, provider, privateKey, cipher);
                        return byArray;
                    }
                    catch (Exception e4) {
                        logger.debug((Object)("Error RSA para el descifrado seg\u00fan: " + this.usedAlgorithm + " con el proveedor " + provider), (Throwable)e4);
                        try {
                            byte[] ciphertext;
                            this.usedAlgorithm = RSA_ECB_PKCS1;
                            Cipher cipher = Cipher.getInstance(this.usedAlgorithm);
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Empleando el algoritmo " + this.usedAlgorithm + " con el proveedor " + cipher.getProvider().getName()));
                            }
                            byte[] byArray = ciphertext = this.decryptText(cryptedText, provider, privateKey, cipher);
                            return byArray;
                        }
                        catch (Exception e5) {
                            logger.debug((Object)"No se pudo desencriptar", (Throwable)e5);
                            throw new SecurityException("Error RSA - No se pudo desencriptar", e2);
                        }
                    }
                }
            }
            finally {
                if (provider != null && Security.getProvider(provider.getName()) != null) {
                    Security.removeProvider(provider.getName());
                }
            }
        }
    }

    private byte[] decryptText(char[] cryptedText, Provider provider, PrivateKey privateKey, Cipher cipher) throws InvalidKeyException, NoSuchAlgorithmException, IllegalBlockSizeException, BadPaddingException {
        byte[] ciphertext;
        if (provider != null && provider.getName() != null && provider.getName().contains("Mozilla-JSS")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Recuperando clave a trav\u00e9s de Mozilla-JSS");
            }
            cipher.init(4, privateKey);
            ciphertext = cipher.unwrap(Base64Coder.decode((Object)cryptedText), "DESede", 3).getEncoded();
        } else {
            cipher.init(2, privateKey);
            ciphertext = cipher.doFinal(Base64Coder.decode((Object)cryptedText));
        }
        return ciphertext;
    }

    public String genNewRSAKeys(String password) {
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance(RSA, "BC");
            generator.initialize(1024, this.random);
            KeyPair newKeys = generator.generateKeyPair();
            byte[] pbcBuffer = newKeys.getPublic().getEncoded();
            byte[] pvtBuffer = newKeys.getPrivate().getEncoded();
            int totalSize = pbcBuffer.length + pvtBuffer.length + 4;
            byte[] pairData = new byte[totalSize];
            char[] pubSize = String.valueOf(pbcBuffer.length).toCharArray();
            int i = 0;
            while (i < pubSize.length) {
                pairData[i] = (byte)pubSize[i];
                ++i;
            }
            i = 0;
            while (i < pbcBuffer.length) {
                pairData[i + 4] = pbcBuffer[i];
                ++i;
            }
            i = pbcBuffer.length + 4;
            while (i < totalSize) {
                pairData[i] = pvtBuffer[i - (pbcBuffer.length + 4)];
                ++i;
            }
            if (this.simetricCipher == null) {
                this.simetricCipher = new TripleDESManager();
            }
            char[] encPairChar = this.simetricCipher.protectTripleDES(pairData, password);
            return new String(encPairChar);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityException(e);
        }
        catch (NoSuchProviderException e) {
            throw new SecurityException(e);
        }
    }

    public KeyPair unprotectKeyPair(String encPair, String password) throws SecurityException {
        return this.unprotectKeyPair(encPair.toCharArray(), password);
    }

    public KeyPair unprotectKeyPair(char[] encPairChar, String password) throws SecurityException {
        if (this.simetricCipher == null) {
            this.simetricCipher = new TripleDESManager();
        }
        byte[] pair = this.simetricCipher.recoverTripleDES(encPairChar, password);
        int pubKeySize = 0;
        int cifra = 0;
        int i = 0;
        while (i < 4) {
            block10: {
                try {
                    cifra = Integer.valueOf(String.valueOf((char)pair[i]));
                    if (cifra < 0 || cifra > 9) break block10;
                    pubKeySize = pubKeySize * 10 + cifra;
                }
                catch (NumberFormatException e) {
                    break;
                }
            }
            ++i;
        }
        byte[] publicKeyData = new byte[pubKeySize];
        byte[] privateKeyData = new byte[pair.length - pubKeySize - 4];
        int i2 = 4;
        while (i2 < pubKeySize + 4) {
            publicKeyData[i2 - 4] = pair[i2];
            ++i2;
        }
        i2 = pubKeySize + 4;
        while (i2 < pair.length) {
            privateKeyData[i2 - (pubKeySize + 4)] = pair[i2];
            ++i2;
        }
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(RSA, "BC");
            PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(privateKeyData);
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(publicKeyData);
            return new KeyPair(keyFactory.generatePublic(publicKeySpec), keyFactory.generatePrivate(privateKeySpec));
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityException(e);
        }
        catch (InvalidKeySpecException e) {
            throw new SecurityException(e);
        }
        catch (NoSuchProviderException e) {
            throw new SecurityException(e);
        }
    }

    @Override
    public String getUsedAlgorithmURI() {
        if (this.usedAlgorithm == RSA_OAEP_KEY) {
            return "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
        }
        return "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
    }

    public static void main(String[] args) {
        RSAManager p = new RSAManager();
        System.out.println("Se solicita el c\u00e1lculo de un nuevo par de claves asim\u00e9tricas de 1024 bits");
        Long start = System.currentTimeMillis();
        String protectedPair = p.genNewRSAKeys("ecoestadisticassrepals");
        KeyPair pair = p.unprotectKeyPair(protectedPair, "ecoestadisticassrepals");
        Long time = System.currentTimeMillis() - start;
        System.out.println("Claves obtenidas. Tiempo consumido (ms): " + time + ". Comienzan las pruebas de encriptaci\u00f3n...");
        System.out.println("Texto en claro: " + args[0]);
        String buffer = args[0];
        char[] bufferChar = p.protectRSA(buffer, (Key)pair.getPrivate());
        buffer = new String(bufferChar);
        System.out.println("Texto encriptado RSA con privada: " + buffer);
        buffer = new String(p.recoverRSA(bufferChar, pair.getPublic()));
        System.out.println("Texto desencriptado RSA con p\u00fablica: " + buffer);
        start = System.currentTimeMillis();
        buffer = Utils.obfuscate(new String(p.protectRSA(buffer, (Key)pair.getPublic())));
        System.out.println("Encriptado RSA con p\u00fablica y ofuscado: " + buffer);
        buffer = new String(p.recoverRSA(Utils.undoObfuscate(buffer.getBytes()).toCharArray(), pair.getPrivate()));
        time = System.currentTimeMillis() - start;
        System.out.println("Texto recuperado con privada: " + buffer + "\nTiempo consumido (ms): " + time);
    }
}

