/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.pkstore.mitycstore.mantainer;

import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.pkstore.mitycstore.CertUtil;
import es.mityc.javasign.pkstore.mitycstore.mantainer.TypeTreeNode;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class CertificadoModeloTree
extends DefaultTreeModel {
    private static final II18nManager I18N = I18nFactory.getI18nManager((String)"MITyCLibCert");

    public CertificadoModeloTree(DefaultMutableTreeNode root, X509Certificate cert) {
        super(root);
        String datos = "";
        DefaultMutableTreeNode sujeto = new DefaultMutableTreeNode(new TypeTreeNode(I18N.getLocalMessage("i18n.mityc.cert.mityc.25", new Object[]{CertUtil.extractName(cert.getSubjectX500Principal().getName())}), null));
        DefaultMutableTreeNode sujetoDN = new DefaultMutableTreeNode(new TypeTreeNode(I18N.getLocalMessage("i18n.mityc.cert.mityc.26", new Object[]{cert.getSubjectDN()}), null));
        sujeto.add(sujetoDN);
        root.add(sujeto);
        DefaultMutableTreeNode emisor = new DefaultMutableTreeNode(new TypeTreeNode(I18N.getLocalMessage("i18n.mityc.cert.mityc.27", new Object[]{CertUtil.extractName(cert.getIssuerX500Principal().getName())}), null));
        DefaultMutableTreeNode emisorDN = new DefaultMutableTreeNode(new TypeTreeNode(I18N.getLocalMessage("i18n.mityc.cert.mityc.26", new Object[]{cert.getIssuerDN()}), null));
        emisor.add(emisorDN);
        root.add(emisor);
        String aviso = "";
        if (new Date().before(cert.getNotBefore())) {
            aviso = I18N.getLocalMessage("i18n.mityc.cert.mityc.32");
        }
        if (new Date().after(cert.getNotAfter())) {
            aviso = I18N.getLocalMessage("i18n.mityc.cert.mityc.33");
        }
        datos = String.valueOf(I18N.getLocalMessage("i18n.mityc.cert.mityc.34", new Object[]{CertUtil.convertDate(cert.getNotBefore()), CertUtil.convertDate(cert.getNotAfter())})) + aviso;
        DefaultMutableTreeNode validez = new DefaultMutableTreeNode(new TypeTreeNode(I18N.getLocalMessage("i18n.mityc.cert.mityc.28", new Object[]{datos}), null));
        root.add(validez);
        datos = cert.getSerialNumber().toString();
        DefaultMutableTreeNode nroSerie = new DefaultMutableTreeNode(new TypeTreeNode(I18N.getLocalMessage("i18n.mityc.cert.mityc.29", new Object[]{datos}), null));
        root.add(nroSerie);
        StringBuilder claveUsoString = new StringBuilder("");
        String[] clavesUsadasArray = new String[]{I18N.getLocalMessage("i18n.mityc.cert.mityc.35"), I18N.getLocalMessage("i18n.mityc.cert.mityc.36"), I18N.getLocalMessage("i18n.mityc.cert.mityc.37"), I18N.getLocalMessage("i18n.mityc.cert.mityc.38"), I18N.getLocalMessage("i18n.mityc.cert.mityc.39"), I18N.getLocalMessage("i18n.mityc.cert.mityc.40"), I18N.getLocalMessage("i18n.mityc.cert.mityc.41"), I18N.getLocalMessage("i18n.mityc.cert.mityc.42"), I18N.getLocalMessage("i18n.mityc.cert.mityc.43")};
        boolean[] claveUso = cert.getKeyUsage();
        if (claveUso != null) {
            int z = 0;
            while (z < claveUso.length) {
                if (claveUso[z]) {
                    claveUsoString.append(clavesUsadasArray[z]);
                    claveUsoString.append(", ");
                }
                ++z;
            }
            claveUsoString.deleteCharAt(claveUsoString.length() - 1);
        } else {
            claveUsoString.append(I18N.getLocalMessage("i18n.mityc.cert.mityc.44"));
        }
        DefaultMutableTreeNode uso = new DefaultMutableTreeNode(new TypeTreeNode(I18N.getLocalMessage("i18n.mityc.cert.mityc.30", new Object[]{claveUsoString.toString()}), null));
        root.add(uso);
        try {
            datos = cert.getSigAlgName();
        }
        catch (Throwable t) {
            datos = I18N.getLocalMessage("i18n.mityc.cert.mityc.45");
        }
        DefaultMutableTreeNode algoritmo = new DefaultMutableTreeNode(new TypeTreeNode(I18N.getLocalMessage("i18n.mityc.cert.mityc.31", new Object[]{datos}), null));
        root.add(algoritmo);
    }
}

