/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.pkstore.mitycstore;

import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.pkstore.CertStoreException;
import es.mityc.javasign.pkstore.IPKStoreMaintainer;
import es.mityc.javasign.pkstore.IPKStoreManager;
import es.mityc.javasign.pkstore.IPassStoreKS;
import es.mityc.javasign.pkstore.mitycstore.PKContextDialog;
import es.mityc.javasign.pkstore.mitycstore.PKHandlers.CachedPassHandler;
import es.mityc.javasign.pkstore.mitycstore.PKHandlers.DeleteWarnHandler;
import es.mityc.javasign.pkstore.mitycstore.PKHandlers.Pkcs11PassHandler;
import es.mityc.javasign.pkstore.mitycstore.PKHandlers.PlainPassHandler;
import es.mityc.javasign.pkstore.mitycstore.PKHandlers.TranslucentPassHandler;
import es.mityc.javasign.pkstore.mitycstore.PKHandlers.WarnPassHandler;
import es.mityc.javasign.pkstore.mitycstore.mantainer.CertCellRenderer;
import es.mityc.javasign.pkstore.mitycstore.mantainer.DriverTblModel;
import es.mityc.javasign.pkstore.mitycstore.mantainer.KSManagerDialog;
import es.mityc.javasign.pkstore.pkcs11.ConfigMultiPKCS11;
import es.mityc.javasign.pkstore.pkcs11.MultiPKCS11Store;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MITyCStore
implements IPKStoreManager,
IPKStoreMaintainer {
    private static final Log LOG = LogFactory.getLog(MITyCStore.class);
    private static final II18nManager I18N = I18nFactory.getI18nManager((String)"MITyCLibCert");
    private static final int RND_MAX_SIZE = 10000;
    private final String ksAlias = "MITyCKeyStoreAlias";
    private static File confFile = null;
    private Properties prop = null;
    private boolean autocreate = false;
    private static String ksURL = null;
    private IPassStoreKS passKs = null;
    private HashMap<String, CachedPassHandler> passKsCachedList = null;
    private IPassStoreKS noPassWarnKs = null;
    private IPassStoreKS noPassNoWarnKs = null;
    private IPassStoreKS smartCrdPassKs = null;
    private KeyStore ks = null;
    private HashMap<String, String> drvrList = new HashMap();
    private MultiPKCS11Store pkcs11s = null;
    private AliasFormat aliasFormat = null;

    public static MITyCStore getInstance(File config, boolean auto) throws CertStoreException {
        InputStream is = null;
        if (config != null) {
            confFile = config;
            try {
                is = new FileInputStream(confFile);
            }
            catch (FileNotFoundException e) {
                LOG.error((Object)("No se pudo cargar la configuraci\u00f3n indicada: " + confFile.getPath() + "\nSe carga la configuraci\u00f3n por defecto"));
            }
        }
        if (is == null) {
            is = KSManagerDialog.class.getResourceAsStream("/MITyC_KS.properties");
        }
        return new MITyCStore(is, true);
    }

    public MITyCStore(InputStream config) throws CertStoreException {
        this(config, false);
    }

    public MITyCStore(InputStream config, boolean auto) throws CertStoreException {
        this.prop = new Properties();
        try {
            this.prop.load(config);
        }
        catch (IOException e) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mityc.59"), (Throwable)e);
        }
        this.autocreate = auto;
        this.init();
    }

    private void initPassHandlers() {
        this.passKs = new PlainPassHandler();
        this.passKsCachedList = new HashMap();
        this.noPassWarnKs = new WarnPassHandler();
        this.noPassNoWarnKs = new TranslucentPassHandler();
        this.smartCrdPassKs = new Pkcs11PassHandler();
    }

    public CertPath getCertPath(X509Certificate certificate) throws CertStoreException {
        CertPath cp = null;
        if (certificate == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Faltan par\u00e1metros de entrada.");
            }
            return null;
        }
        if (this.ks == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"El almac\u00e9n no est\u00e1 inicializado.");
            }
            return null;
        }
        try {
            String alias = this.ks.getCertificateAlias(certificate);
            if (alias != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("CertPath.- Certificado encontrado en el almac\u00e9n: " + alias));
                }
                Certificate[] certArray = this.ks.getCertificateChain(alias);
                ArrayList<X509Certificate> certChain = new ArrayList<X509Certificate>();
                X509Certificate rootCert = (X509Certificate)certArray[0];
                certChain.add(rootCert);
                int i = 1;
                while (i < certArray.length) {
                    certChain.add((X509Certificate)certArray[i]);
                    ++i;
                }
                cp = CertificateFactory.getInstance("X.509", "BC").generateCertPath(certChain);
            }
        }
        catch (KeyStoreException e1) {
            LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mityc.1"), (Throwable)e1);
            return null;
        }
        catch (CertificateException e) {
            LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mityc.2"), (Throwable)e);
        }
        catch (NoSuchProviderException e) {
            LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mityc.3"), (Throwable)e);
            return null;
        }
        return cp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrivateKey getPrivateKey(X509Certificate certificate) throws CertStoreException {
        String alias;
        block22: {
            block23: {
                if (certificate == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Faltan par\u00e1metros de entrada.");
                    }
                    return null;
                }
                if (this.ks == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"El almac\u00e9n no est\u00e1 inicializado.");
                    }
                    return null;
                }
                alias = null;
                alias = this.ks.getCertificateAlias(certificate);
                if (alias == null) break block22;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("PrivateKey.- Certificado encontrado en el almac\u00e9n: " + alias));
                }
                if (!this.ks.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class)) break block23;
                KeyStore.PasswordProtection kpp = null;
                this.aliasFormat = new AliasFormat(alias);
                if (this.aliasFormat.isProtected()) {
                    if (this.aliasFormat.isPassCached()) {
                        CachedPassHandler handler = null;
                        HashMap<String, CachedPassHandler> hashMap = this.passKsCachedList;
                        synchronized (hashMap) {
                            handler = this.passKsCachedList.get(alias);
                            if (handler == null) {
                                handler = new CachedPassHandler();
                                this.passKsCachedList.put(alias, handler);
                            }
                        }
                        kpp = new KeyStore.PasswordProtection(handler.getPassword(certificate, null));
                    } else {
                        kpp = new KeyStore.PasswordProtection(this.passKs.getPassword(certificate, null));
                    }
                } else {
                    kpp = this.aliasFormat.isMayWarning() ? new KeyStore.PasswordProtection(this.noPassWarnKs.getPassword(certificate, alias)) : new KeyStore.PasswordProtection(this.noPassNoWarnKs.getPassword(certificate, alias));
                }
                if (kpp.getPassword() == null) {
                    LOG.info((Object)I18N.getLocalMessage("i18n.mityc.cert.mityc.81"));
                    throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mityc.81"));
                }
                KeyStore.PrivateKeyEntry pke = (KeyStore.PrivateKeyEntry)this.ks.getEntry(alias, kpp);
                if (pke != null) {
                    return pke.getPrivateKey();
                }
                LOG.warn((Object)I18N.getLocalMessage("i18n.mityc.cert.mityc.6"));
                return null;
            }
            LOG.warn((Object)I18N.getLocalMessage("i18n.mityc.cert.mityc.6"));
            return null;
        }
        try {
            PrivateKey pk = this.pkcs11s.getPrivateKey(certificate);
            return pk;
        }
        catch (KeyStoreException e1) {
            LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mityc.1"), (Throwable)e1);
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mityc.7"), (Throwable)e);
            return null;
        }
        catch (UnrecoverableEntryException e) {
            CachedPassHandler handler = this.passKsCachedList.get(alias);
            if (handler != null) {
                handler.reset();
            }
            LOG.warn((Object)I18N.getLocalMessage("i18n.mityc.cert.mityc.8"));
            return null;
        }
    }

    public Provider getProvider(X509Certificate cert) {
        Provider certProvider = null;
        if (this.pkcs11s != null) {
            certProvider = this.pkcs11s.getProvider(cert);
        }
        if (certProvider != null) {
            return certProvider;
        }
        if (this.ks != null) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"El almac\u00e9n de certificados a\u00fan no ha sido inicializado");
        }
        return null;
    }

    public List<X509Certificate> getSignCertificates() throws CertStoreException {
        List<X509Certificate> signCerts11;
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        if (this.ks == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"El almac\u00e9n no est\u00e1 inicializado.");
            }
            return null;
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Obteniendo certificados de firma: Tama\u00f1o del almac\u00e9n: " + this.ks.size()));
            }
            Enumeration<String> aliases = this.ks.aliases();
            String alias = null;
            while (aliases.hasMoreElements()) {
                alias = aliases.nextElement();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("  - Alias del certificado: " + alias));
                }
                if (!this.ks.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class)) continue;
                certs.add((X509Certificate)this.ks.getCertificate(alias));
            }
        }
        catch (KeyStoreException e1) {
            LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mityc.1"), (Throwable)e1);
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Lectura.- Accediendo a los m\u00f3dulos PKCS11");
        }
        if ((signCerts11 = this.pkcs11s.getSignCertificates()) != null) {
            certs.addAll(signCerts11);
        }
        return certs;
    }

    public List<X509Certificate> getTrustCertificates() throws CertStoreException {
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        if (this.ks == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"El almac\u00e9n no est\u00e1 inicializado.");
            }
            return null;
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Obteniendo certificados de autenticaci\u00f3n.- Tama\u00f1o del almac\u00e9n: " + this.ks.size()));
            }
            Enumeration<String> aliases = this.ks.aliases();
            String alias = null;
            while (aliases.hasMoreElements()) {
                alias = aliases.nextElement();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("  - Alias del certificado: " + alias));
                }
                if (!this.ks.entryInstanceOf(alias, KeyStore.TrustedCertificateEntry.class)) continue;
                certs.add((X509Certificate)this.ks.getCertificate(alias));
            }
        }
        catch (KeyStoreException e1) {
            LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mityc.9"), (Throwable)e1);
            return null;
        }
        return certs;
    }

    public List<X509Certificate> getPublicCertificates() throws CertStoreException {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init() throws CertStoreException {
        block49: {
            FileInputStream fis = null;
            try {
                this.ks = KeyStore.getInstance("JCEKS");
            }
            catch (KeyStoreException e2) {
                throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mityc.10"), (Throwable)e2);
            }
            if (this.ks == null) {
                if (!LOG.isDebugEnabled()) return;
                LOG.debug((Object)"No se pudo instanciar el almac\u00e9n.");
                return;
            }
            this.initPassHandlers();
            ksURL = this.prop.getProperty("KeyStoreName");
            if (ksURL == null) {
                throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mityc.11"));
            }
            ksURL = ksURL.trim();
            this.prop.remove("KeyStoreName");
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("El almac\u00e9n se espera en: " + ksURL));
            }
            if (ksURL != null && new File(ksURL).exists() && new File(ksURL).length() != 0L) {
                try {
                    fis = new FileInputStream(ksURL);
                    this.ks.load(fis, new char[0]);
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                    if (fis == null) break block49;
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                    break block49;
                }
                catch (CertificateException e) {
                    e.printStackTrace();
                    break block49;
                }
                catch (IOException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Se reintenta el acceso.- El almac\u00e9n puede estar protegido con contrase\u00f1a.");
                    }
                    try {
                        CachedPassHandler handler = null;
                        HashMap<String, CachedPassHandler> hashMap = this.passKsCachedList;
                        synchronized (hashMap) {
                            handler = this.passKsCachedList.get("MITyCKeyStoreAlias");
                            if (handler == null) {
                                handler = new CachedPassHandler();
                                this.passKsCachedList.put("MITyCKeyStoreAlias", handler);
                            }
                        }
                        fis = new FileInputStream(ksURL);
                        this.ks.load(fis, handler.getPassword(null, I18N.getLocalMessage("i18n.mityc.cert.mityc.12")));
                    }
                    catch (NoSuchAlgorithmException ex) {
                        e.printStackTrace();
                    }
                    catch (CertificateException ex) {
                        e.printStackTrace();
                    }
                    catch (IOException ex) {
                        if (!LOG.isDebugEnabled()) throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mityc.85"));
                        LOG.debug((Object)I18N.getLocalMessage("i18n.mityc.cert.mityc.85"), (Throwable)ex);
                        throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mityc.85"));
                    }
                    if (fis == null) break block49;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                    break block49;
                }
                {
                    finally {
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                if (fis == null) break block49;
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            } else {
                if (!this.autocreate) throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mityc.13"));
                try {
                    this.ks.load(null);
                    this.saveStore();
                }
                catch (NoSuchAlgorithmException e1) {
                    e1.printStackTrace();
                }
                catch (CertificateException e1) {
                    e1.printStackTrace();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Acceso al almac\u00e9n MITyC exitoso.");
        }
        Enumeration<Object> keys = this.prop.keys();
        ArrayList<String> prefijos = new ArrayList<String>();
        while (keys.hasMoreElements()) {
            String key = ((String)keys.nextElement()).trim();
            if (prefijos.contains(key = key.substring(0, key.indexOf(46)))) continue;
            prefijos.add(key);
        }
        ConfigMultiPKCS11 config = new ConfigMultiPKCS11();
        int i = 0;
        while (i < prefijos.size()) {
            block52: {
                try {
                    String lib = this.prop.getProperty(String.valueOf((String)prefijos.get(i)) + ".library");
                    if (lib != null && new File(lib.trim()) != null && new File(lib.trim()).exists()) {
                        block51: {
                            lib = lib.trim();
                            try {
                                config.addSunProvider(this.prop.getProperty(String.valueOf((String)prefijos.get(i)) + ".name").trim(), lib);
                            }
                            catch (NoSuchProviderException ex) {
                                LOG.error((Object)ex.getMessage());
                                if (!LOG.isDebugEnabled()) break block51;
                                LOG.debug((Object)"", (Throwable)ex);
                            }
                        }
                        this.drvrList.put(this.prop.getProperty(String.valueOf((String)prefijos.get(i)) + ".name").trim(), lib);
                        break block52;
                    }
                    LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mityc.92", new Object[]{lib}));
                }
                catch (MissingResourceException ex) {
                    LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mityc.14"));
                }
            }
            ++i;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Cargando pasarelas PKCS11");
        }
        this.pkcs11s = new MultiPKCS11Store(config, this.smartCrdPassKs);
    }

    public void addTrustCert(X509Certificate cert) throws CertStoreException {
        if (cert == null) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mityc.15"));
        }
        if (this.ks == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"El almac\u00e9n no est\u00e1 inicializado.");
            }
            return;
        }
        String newAlias = this.genNewAlias("SignCert");
        try {
            KeyStore.TrustedCertificateEntry ksEntry = new KeyStore.TrustedCertificateEntry(cert);
            this.ks.setEntry(newAlias, ksEntry, null);
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
            return;
        }
        this.saveStore();
    }

    public void importSignCert(PrivateKey pk, X509Certificate cert, char[] password) throws CertStoreException {
        block8: {
            if (pk == null || cert == null || password == null) {
                throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mityc.15"));
            }
            if (this.ks == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"El almac\u00e9n no est\u00e1 inicializado.");
                }
                return;
            }
            PKContextDialog contextDialog = new PKContextDialog(null, this);
            contextDialog.setVisible(true);
            String newAlias = this.genNewAlias(String.valueOf(contextDialog.getContext()) + "SignCert");
            try {
                try {
                    KeyStore.PrivateKeyEntry ksEntry = new KeyStore.PrivateKeyEntry(pk, new Certificate[]{cert});
                    KeyStore.PasswordProtection pp = new KeyStore.PasswordProtection(contextDialog.getPass());
                    this.ks.setEntry(newAlias, ksEntry, pp);
                }
                catch (KeyStoreException e) {
                    e.printStackTrace();
                    contextDialog.dispose();
                    break block8;
                }
            }
            catch (Throwable throwable) {
                contextDialog.dispose();
                throw throwable;
            }
            contextDialog.dispose();
        }
        this.saveStore();
    }

    public void removeSignCert(X509Certificate cert) throws CertStoreException {
        if (cert == null) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mityc.15"));
        }
        if (this.ks == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"El almac\u00e9n no est\u00e1 inicializado.");
            }
            return;
        }
        String alias = null;
        try {
            alias = this.ks.getCertificateAlias(cert);
            if (this.ks.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class)) {
                KeyStore.PasswordProtection kpp = null;
                this.aliasFormat = new AliasFormat(alias);
                kpp = this.aliasFormat.isProtected() ? new KeyStore.PasswordProtection(this.passKs.getPassword(cert, null)) : new KeyStore.PasswordProtection(new DeleteWarnHandler().getPassword(cert, alias));
                if (kpp.getPassword() == null) {
                    LOG.info((Object)I18N.getLocalMessage("i18n.mityc.cert.mityc.81"));
                    throw new CertStoreException("Cancelado por el usuario.");
                }
                this.ks.getEntry(alias, kpp);
                this.ks.deleteEntry(alias);
                this.saveStore();
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"No es un certificado de firma asociado a una clave privada.");
            }
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
            return;
        }
        catch (UnrecoverableEntryException e) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mityc.82"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mityc.82"));
        }
    }

    public void removeTrustCert(X509Certificate cert) throws CertStoreException {
        if (cert == null) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mityc.15"));
        }
        if (this.ks == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"El almac\u00e9n no est\u00e1 inicializado.");
            }
            return;
        }
        String alias = null;
        try {
            alias = this.ks.getCertificateAlias(cert);
            if (this.ks.entryInstanceOf(alias, KeyStore.TrustedCertificateEntry.class)) {
                this.ks.deleteEntry(alias);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"No es un certificado de autenticaci\u00f3n.");
            }
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
            return;
        }
        this.saveStore();
    }

    public void updateSignCert(X509Certificate newCert) throws CertStoreException {
        if (newCert == null) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mityc.15"));
        }
        if (this.ks == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"El almac\u00e9n no est\u00e1 inicializado.");
            }
            return;
        }
        try {
            PublicKey pubKey = newCert.getPublicKey();
            String foundAlias = null;
            Iterator<X509Certificate> signCerts = this.getSignCertificates().iterator();
            X509Certificate signCert = null;
            while (signCerts.hasNext()) {
                signCert = signCerts.next();
                if (!pubKey.equals(signCert.getPublicKey())) continue;
                foundAlias = this.ks.getCertificateAlias(signCert);
                break;
            }
            if (foundAlias != null) {
                if (!this.isDeletable(newCert) || !this.ks.entryInstanceOf(foundAlias, KeyStore.PrivateKeyEntry.class)) {
                    throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mityc.93"));
                }
            } else {
                throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mityc.16"));
            }
            this.ks.setCertificateEntry(foundAlias, newCert);
            this.saveStore();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
    }

    public boolean isDeletable(X509Certificate cert) {
        boolean borrable = true;
        try {
            borrable = this.ks.getCertificateAlias(cert) != null;
        }
        catch (KeyStoreException ex) {
            borrable = false;
        }
        return borrable;
    }

    /*
     * Exception decompiling
     */
    private boolean saveStore() throws CertStoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [20[CATCHBLOCK]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void saveConf() throws CertStoreException {
        if (confFile == null) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mityc.96"));
        }
        this.prop = new Properties();
        if (ksURL == null) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mityc.11"));
        }
        this.prop.setProperty("KeyStoreName", ksURL);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("El almac\u00e9n se buscar\u00e1 en: " + ksURL));
        }
        Iterator<Map.Entry<String, String>> contents = this.drvrList.entrySet().iterator();
        Map.Entry<String, String> content = null;
        while (contents.hasNext()) {
            content = contents.next();
            this.prop.put(String.valueOf(content.getKey().toLowerCase()) + ".name", content.getKey());
            this.prop.put(String.valueOf(content.getKey().toLowerCase()) + ".library", content.getValue());
        }
        try {
            FileOutputStream fos = new FileOutputStream(confFile);
            this.prop.store(fos, null);
        }
        catch (Exception e) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mityc.96"), (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    public void setNewPass(char[] oldPass, char[] newPass) throws CertStoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [24[CATCHBLOCK]], but top level block is 10[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String genNewAlias(String prefix) {
        Random rnd = new Random();
        String alias = String.valueOf(prefix) + rnd.nextInt(10000);
        try {
            while (this.ks.containsAlias(alias)) {
                alias = String.valueOf(prefix) + rnd.nextInt(10000);
            }
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        return alias;
    }

    public JPanel getPreferencesPanel() {
        return new PreferencesPanel(this, this.drvrList);
    }

    protected void setNewMultiPkcs11(HashMap<String, String> newDrvrList) throws CertStoreException {
        if (newDrvrList == null) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.mityc.15"));
        }
        this.drvrList = newDrvrList;
        ConfigMultiPKCS11 config = new ConfigMultiPKCS11();
        Iterator<Map.Entry<String, String>> contents = newDrvrList.entrySet().iterator();
        Map.Entry<String, String> content = null;
        String lib = null;
        while (contents.hasNext()) {
            content = contents.next();
            lib = content.getValue();
            try {
                if (lib != null && new File(lib) != null && new File(lib).exists()) {
                    try {
                        config.addSunProvider(content.getKey(), lib);
                    }
                    catch (NoSuchProviderException ex) {
                        LOG.error((Object)ex.getMessage());
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)"", (Throwable)ex);
                    }
                    continue;
                }
                LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mityc.92", new Object[]{lib}));
            }
            catch (MissingResourceException ex) {
                LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mityc.14"));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Cargando pasarelas PKCS11");
        }
        this.pkcs11s = new MultiPKCS11Store(config, this.smartCrdPassKs);
    }

    protected class AliasFormat {
        private final char keyProtected = (char)112;
        private final char keyUnprotected = (char)117;
        private boolean isProtected = true;
        private boolean isPassCached = false;
        private boolean mayWarning = false;

        /*
         * Enabled aggressive block sorting
         */
        public AliasFormat(String alias) {
            if (alias == null || alias.length() <= 0) {
                if (!LOG.isDebugEnabled()) return;
                LOG.debug((Object)"El alias no cumple con el formato");
                return;
            }
            char[] aliasArray = alias.toCharArray();
            if ('p' == aliasArray[0]) {
                if ('0' == aliasArray[1]) {
                    this.isProtected = true;
                    this.isPassCached = false;
                    this.mayWarning = false;
                    return;
                }
                if ('1' == aliasArray[1]) {
                    this.isProtected = true;
                    this.isPassCached = true;
                    this.mayWarning = false;
                    return;
                }
                if (!LOG.isDebugEnabled()) return;
                LOG.debug((Object)"El alias no cumple con el formato");
                return;
            }
            if ('u' != aliasArray[0]) return;
            if ('0' == aliasArray[1]) {
                this.isProtected = false;
                this.isPassCached = false;
                this.mayWarning = false;
                return;
            }
            if ('1' == aliasArray[1]) {
                this.isProtected = false;
                this.isPassCached = false;
                this.mayWarning = true;
                return;
            }
            if (!LOG.isDebugEnabled()) return;
            LOG.debug((Object)"El alias no cumple con el formato");
        }

        public String genAliasPrefix(boolean isPro, boolean isCached, boolean mayWarn) {
            StringBuffer sb = new StringBuffer("");
            if (isPro) {
                sb.append('p');
                if (isCached) {
                    sb.append('1');
                } else {
                    sb.append('0');
                }
            } else {
                sb.append('u');
                if (mayWarn) {
                    sb.append('1');
                } else {
                    sb.append('0');
                }
            }
            sb.append("00");
            return sb.toString();
        }

        public boolean isProtected() {
            return this.isProtected;
        }

        public boolean isPassCached() {
            return this.isPassCached;
        }

        public boolean isMayWarning() {
            return this.mayWarning;
        }
    }

    private class PreferencesPanel
    extends JPanel {
        private static final int WIDTH = 350;
        private static final int HEIGHT = 265;
        private HashMap<String, String> drivrList = null;
        private MITyCStore store = null;
        private JTabbedPane tabs = null;
        private JButton aceptarButton = null;
        private JPanel storePass = null;
        private JLabel oldPassLabel = null;
        private JPasswordField oldPassField = null;
        private JLabel newPassLabel = null;
        private JPasswordField newPassField = null;
        private JCheckBox noPassCheck = null;
        private JPanel pkcs11Admon = null;
        private JScrollPane driversScroll = null;
        private JTable driversTbl = null;
        private JButton addDrvrButton = null;
        private JButton delDrvrButton = null;

        public PreferencesPanel(MITyCStore keyStore, HashMap<String, String> drvrList) {
            this.store = keyStore;
            this.drivrList = drvrList;
            this.init();
        }

        private void init() {
            this.setBorder(BorderFactory.createTitledBorder(I18N.getLocalMessage("i18n.mityc.cert.mityc.90")));
            this.tabs = new JTabbedPane();
            this.storePass = new JPanel();
            this.oldPassLabel = new JLabel(I18N.getLocalMessage("i18n.mityc.cert.mityc.87"));
            this.oldPassLabel.setHorizontalAlignment(4);
            this.oldPassField = new JPasswordField();
            this.newPassLabel = new JLabel(I18N.getLocalMessage("i18n.mityc.cert.mityc.88"));
            this.newPassLabel.setHorizontalAlignment(4);
            this.newPassField = new JPasswordField();
            this.noPassCheck = new JCheckBox(I18N.getLocalMessage("i18n.mityc.cert.mityc.89"));
            this.noPassCheck.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    PreferencesPanel.this.noPassActionPerformed(e);
                }
            });
            this.aceptarButton = new JButton();
            this.setLayout(new GridBagLayout());
            this.storePass.setLayout(new GridBagLayout());
            GridBagConstraints oldPassLblConstraints = new GridBagConstraints();
            oldPassLblConstraints.gridx = 0;
            oldPassLblConstraints.gridy = 0;
            oldPassLblConstraints.insets = new Insets(5, 10, 3, 3);
            oldPassLblConstraints.anchor = 13;
            this.storePass.add((Component)this.oldPassLabel, oldPassLblConstraints);
            GridBagConstraints oldPassFldConstraints = new GridBagConstraints();
            oldPassFldConstraints.gridx = 1;
            oldPassFldConstraints.gridy = 0;
            oldPassFldConstraints.fill = 2;
            oldPassFldConstraints.weightx = 1.0;
            oldPassFldConstraints.gridwidth = 2;
            oldPassFldConstraints.insets = new Insets(5, 3, 3, 20);
            this.storePass.add((Component)this.oldPassField, oldPassFldConstraints);
            GridBagConstraints newPassLblConstraints = new GridBagConstraints();
            newPassLblConstraints.gridx = 0;
            newPassLblConstraints.gridy = 1;
            newPassLblConstraints.insets = new Insets(5, 10, 3, 3);
            newPassLblConstraints.anchor = 13;
            this.storePass.add((Component)this.newPassLabel, newPassLblConstraints);
            GridBagConstraints newPassFldConstraints = new GridBagConstraints();
            newPassFldConstraints.gridx = 1;
            newPassFldConstraints.gridy = 1;
            newPassFldConstraints.weightx = 1.0;
            newPassFldConstraints.fill = 2;
            newPassFldConstraints.insets = new Insets(5, 3, 3, 20);
            this.storePass.add((Component)this.newPassField, newPassFldConstraints);
            GridBagConstraints noPassCheckConstraints = new GridBagConstraints();
            noPassCheckConstraints.gridx = 0;
            noPassCheckConstraints.gridy = 2;
            noPassCheckConstraints.insets = new Insets(5, 10, 3, 10);
            noPassCheckConstraints.gridwidth = 3;
            noPassCheckConstraints.anchor = 10;
            this.storePass.add((Component)this.noPassCheck, noPassCheckConstraints);
            this.pkcs11Admon = new JPanel();
            this.driversTbl = new JTable();
            this.driversTbl.setDefaultRenderer(Object.class, new CertCellRenderer());
            this.driversTbl.setSelectionMode(0);
            this.driversTbl.setPreferredScrollableViewportSize(new Dimension(500, 200));
            this.driversTbl.setModel(new DriverTblModel(this.drivrList));
            this.driversTbl.setAutoResizeMode(4);
            this.driversTbl.getColumnModel().getColumn(1).setPreferredWidth(250);
            this.driversTbl.getColumnModel().getColumn(1).setMaxWidth(250);
            this.driversTbl.getColumnModel().getColumn(1).setMinWidth(250);
            this.driversTbl.getColumnModel().getColumn(1).setWidth(250);
            this.driversScroll = new JScrollPane(this.driversTbl);
            this.addDrvrButton = new JButton();
            this.addDrvrButton.setText(I18N.getLocalMessage("i18n.mityc.cert.mityc.71"));
            this.addDrvrButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PreferencesPanel.this.addDriverBtnActionPerformed();
                }
            });
            this.delDrvrButton = new JButton();
            this.delDrvrButton.setText(I18N.getLocalMessage("i18n.mityc.cert.mityc.70"));
            this.delDrvrButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PreferencesPanel.this.delDriverBtnActionPerformed();
                }
            });
            this.pkcs11Admon.setLayout(new GridBagLayout());
            GridBagConstraints drvTblConstraints = new GridBagConstraints();
            drvTblConstraints.gridx = 0;
            drvTblConstraints.gridy = 0;
            drvTblConstraints.fill = 2;
            drvTblConstraints.weightx = 1.0;
            drvTblConstraints.gridwidth = 4;
            drvTblConstraints.ipady = 50;
            drvTblConstraints.insets = new Insets(5, 5, 10, 5);
            this.pkcs11Admon.add((Component)this.driversScroll, drvTblConstraints);
            GridBagConstraints addDrvBtnConstraints = new GridBagConstraints();
            addDrvBtnConstraints.gridx = 0;
            addDrvBtnConstraints.gridy = 1;
            addDrvBtnConstraints.gridwidth = 1;
            addDrvBtnConstraints.insets = new Insets(5, 55, 5, 5);
            this.pkcs11Admon.add((Component)this.addDrvrButton, addDrvBtnConstraints);
            GridBagConstraints delDrvBtnConstraints = new GridBagConstraints();
            delDrvBtnConstraints.gridx = 3;
            delDrvBtnConstraints.gridy = 1;
            delDrvBtnConstraints.gridwidth = 1;
            delDrvBtnConstraints.insets = new Insets(5, 30, 5, 5);
            this.pkcs11Admon.add((Component)this.delDrvrButton, delDrvBtnConstraints);
            this.tabs.addTab(I18N.getLocalMessage("i18n.mityc.cert.mityc.20"), this.storePass);
            if (confFile != null) {
                this.tabs.addTab("SmartCards", this.pkcs11Admon);
            }
            GridBagConstraints tabsConstraints = new GridBagConstraints();
            tabsConstraints.gridx = 0;
            tabsConstraints.gridy = 0;
            tabsConstraints.fill = 1;
            tabsConstraints.weightx = 1.0;
            tabsConstraints.weighty = 1.0;
            this.add((Component)this.tabs, tabsConstraints);
            GridBagConstraints aceptarButtonConstraints = new GridBagConstraints();
            aceptarButtonConstraints.gridx = 0;
            aceptarButtonConstraints.gridy = 1;
            aceptarButtonConstraints.anchor = 10;
            aceptarButtonConstraints.insets = new Insets(10, 20, 10, 20);
            this.aceptarButton.setText(I18N.getLocalMessage("i18n.mityc.cert.smartcards.GUI.accept"));
            this.aceptarButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PreferencesPanel.this.jAceptarButtonActionPerformed();
                }
            });
            this.add((Component)this.aceptarButton, aceptarButtonConstraints);
            this.setSize(350, 265);
        }

        private void noPassActionPerformed(ItemEvent e) {
            boolean passEnabled = 2 == e.getStateChange();
            this.newPassLabel.setEnabled(passEnabled);
            this.newPassField.setEnabled(passEnabled);
            this.repaint();
        }

        private void addDriverBtnActionPerformed() {
            int lastPoint;
            String origen = System.getProperty("user.home");
            String osName = System.getProperty("os.name");
            if (!osName.toLowerCase().startsWith("win")) {
                origen = "/usr/Library/OpenSC/bin/opensc-pkcs11.so";
            }
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle(I18N.getLocalMessage("i18n.mityc.cert.mityc.97"));
            chooser.setSelectedFile(new File(origen));
            int returnVal = chooser.showOpenDialog(this.getTopLevelAncestor());
            if (returnVal != 0) {
                LOG.debug((Object)"Cancelado por el usuario.");
                return;
            }
            origen = chooser.getSelectedFile().getAbsolutePath();
            if (origen == null || !origen.contains(".")) {
                return;
            }
            int initialPoint = origen.lastIndexOf(File.separator) + 1;
            if (initialPoint == -1) {
                initialPoint = 0;
            }
            if ((lastPoint = origen.lastIndexOf(".")) == -1) {
                lastPoint = origen.length();
            }
            if (!MITyCStore.this.drvrList.containsValue(origen)) {
                MITyCStore.this.drvrList.put(origen.substring(initialPoint, lastPoint), origen);
                ((DriverTblModel)this.driversTbl.getModel()).addRow(origen.substring(initialPoint, lastPoint), origen);
                this.driversTbl.addNotify();
            }
        }

        private void delDriverBtnActionPerformed() {
            int selIndex = this.driversTbl.getSelectedRow();
            if (selIndex >= 0) {
                String key = (String)this.driversTbl.getModel().getValueAt(selIndex, 0);
                this.drivrList.remove(key);
                ((DriverTblModel)this.driversTbl.getModel()).removeRow(selIndex);
            }
        }

        private void jAceptarButtonActionPerformed() {
            if (this.oldPassField.getPassword() != null && this.oldPassField.getPassword() != new char[0]) {
                char[] newPass = new char[]{};
                if (!this.noPassCheck.isSelected()) {
                    newPass = this.newPassField.getPassword();
                }
                try {
                    this.store.setNewPass(this.oldPassField.getPassword(), newPass);
                }
                catch (CertStoreException e) {
                    JOptionPane.showMessageDialog(this, I18N.getLocalMessage("i18n.mityc.cert.mityc.91"), I18N.getLocalMessage("i18n.mityc.cert.mityc.77"), 0);
                    this.oldPassField.setText("");
                }
            }
            if (this.drivrList != null && confFile != null) {
                try {
                    this.store.setNewMultiPkcs11(this.drivrList);
                    this.store.saveConf();
                }
                catch (CertStoreException e) {
                    JOptionPane.showMessageDialog(this, e.getMessage(), I18N.getLocalMessage("i18n.mityc.cert.mityc.77"), 0);
                    return;
                }
            }
            this.setVisible(false);
            if (this.getTopLevelAncestor() != null && this.getTopLevelAncestor() instanceof JDialog) {
                this.getTopLevelAncestor().setVisible(false);
                ((JDialog)this.getTopLevelAncestor()).dispose();
            }
        }
    }
}

