/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.jse.provider;

import es.gob.jmulticard.card.AuthenticationModeLockedException;
import es.gob.jmulticard.card.CryptoCardException;
import es.gob.jmulticard.card.b;
import es.gob.jmulticard.card.d;
import es.gob.jmulticard.card.dnie.a;
import es.gob.jmulticard.card.dnie.e;
import es.gob.jmulticard.jse.provider.DniePrivateKey;
import es.gob.jmulticard.jse.provider.c;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreSpi;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Logger;

public final class DnieKeyStoreImpl
extends KeyStoreSpi {
    private static final List a = new ArrayList(2);
    private b b = null;

    public Enumeration engineAliases() {
        return Collections.enumeration(a);
    }

    @Override
    public boolean engineContainsAlias(String string) {
        return a.contains(string);
    }

    @Override
    public void engineDeleteEntry(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Certificate engineGetCertificate(String string) {
        if (!this.engineContainsAlias(string)) {
            return null;
        }
        try {
            return this.b.a(string);
        }
        catch (CryptoCardException cryptoCardException) {
            throw new ProviderException(cryptoCardException);
        }
    }

    @Override
    public String engineGetCertificateAlias(Certificate certificate) {
        if (!(certificate instanceof X509Certificate)) {
            return null;
        }
        BigInteger bigInteger = ((X509Certificate)certificate).getSerialNumber();
        for (String string : a) {
            if (((X509Certificate)this.engineGetCertificate(string)).getSerialNumber() != bigInteger) continue;
            return string;
        }
        return null;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String string) {
        X509Certificate x509Certificate;
        if (!this.engineContainsAlias(string)) {
            return null;
        }
        try {
            x509Certificate = this.b.a("CertCAIntermediaDGP");
        }
        catch (AuthenticationModeLockedException authenticationModeLockedException) {
            throw authenticationModeLockedException;
        }
        catch (Exception exception) {
            Logger.getLogger("es.gob.jmulticard").warning("No se ha podido cargar el certificado de la CA intermedia");
            x509Certificate = null;
        }
        if (x509Certificate == null) {
            return new X509Certificate[]{(X509Certificate)this.engineGetCertificate(string)};
        }
        return new X509Certificate[]{(X509Certificate)this.engineGetCertificate(string), x509Certificate};
    }

    @Override
    public Date engineGetCreationDate(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Key engineGetKey(String string, char[] cArray) {
        if (cArray != null) {
            Logger.getLogger("es.gob.jmulticard").warning("Se ha proporcionado una contrasena, pero esta se ignorara, ya que el PIN se gestiona internamente");
        }
        if (!this.engineContainsAlias(string)) {
            return null;
        }
        try {
            d d2 = this.b.b(string);
            if (!(d2 instanceof e)) {
                throw new ProviderException("La clave obtenida de la tarjeta no es del tipo esperado, se ha obtenido: " + d2.getClass().getName());
            }
            return new DniePrivateKey((e)d2);
        }
        catch (CryptoCardException cryptoCardException) {
            throw new ProviderException(cryptoCardException);
        }
    }

    @Override
    public KeyStore.Entry engineGetEntry(String string, KeyStore.ProtectionParameter protectionParameter) {
        if (protectionParameter != null) {
            Logger.getLogger("es.gob.jmulticard").warning("Se ha proporcionado un ProtectionParameter, pero este se ignorara, ya que el PIN se gestiona internamente");
        }
        if (!this.engineContainsAlias(string)) {
            return null;
        }
        PrivateKey privateKey = (PrivateKey)this.engineGetKey(string, null);
        return new KeyStore.PrivateKeyEntry(privateKey, this.engineGetCertificateChain(string));
    }

    @Override
    public boolean engineIsCertificateEntry(String string) {
        return a.contains(string);
    }

    @Override
    public boolean engineIsKeyEntry(String string) {
        return a.contains(string);
    }

    @Override
    public void engineLoad(KeyStore.LoadStoreParameter loadStoreParameter) {
        if (loadStoreParameter != null) {
            throw new IllegalArgumentException("El LoadStoreParameter siempre debe ser null, la contrasena se gestiona internamente");
        }
        this.b = new a(new es.gob.jmulticard.jse.a.a(), null, new c());
    }

    @Override
    public void engineLoad(InputStream inputStream, char[] cArray) {
        if (cArray != null) {
            throw new IllegalArgumentException("La contrasena siempre debe ser null, esta se gestiona internamente");
        }
        this.b = new a(new es.gob.jmulticard.jse.a.a(), null, new c());
    }

    @Override
    public void engineSetCertificateEntry(String string, Certificate certificate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int engineSize() {
        return a.size();
    }

    @Override
    public void engineStore(OutputStream outputStream, char[] cArray) {
        throw new UnsupportedOperationException();
    }

    public boolean engineEntryInstanceOf(String string, Class clazz) {
        if (!this.engineContainsAlias(string)) {
            return false;
        }
        return clazz.equals(KeyStore.PrivateKeyEntry.class);
    }

    static {
        a.add("CertAutenticacion");
        a.add("CertFirmaDigital");
    }
}

