/*
 * Decompiled with CFR 0.152.
 */
package firmador;

import es.mityc.firmaJava.libreria.xades.DataToSign;
import es.mityc.firmaJava.libreria.xades.FirmaXML;
import es.mityc.firmaJava.libreria.xades.XAdESSchemas;
import es.mityc.firmaJava.libreria.xades.elementos.xades.ObjectIdentifier;
import es.mityc.javasign.EnumFormatoFirma;
import es.mityc.javasign.xml.refs.AbstractObjectToSign;
import es.mityc.javasign.xml.refs.InternObjectToSign;
import es.mityc.javasign.xml.refs.ObjectToSign;
import firmador.Respuesta;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class GenericXMLSignature {
    private String pathSignature;
    private String passSignature;
    private String fileToSign;
    private static String nameFile;
    private static String pathFile;

    public String getPathSignature() {
        return this.pathSignature;
    }

    public void setPathSignature(String pathSignature) {
        this.pathSignature = pathSignature;
    }

    public String getPassSignature() {
        return this.passSignature;
    }

    public void setPassSignature(String passSignature) {
        this.passSignature = passSignature;
    }

    public Respuesta execute(String archivo_a_firmar, String Firma_electronica, String clave_firma, String path_archivo_firmado, String nombre_archivo_firmado) throws CertificateException, IOException {
        Respuesta respuest = new Respuesta(true, "OK", "");
        this.fileToSign = archivo_a_firmar;
        this.pathSignature = Firma_electronica;
        this.passSignature = clave_firma;
        pathFile = path_archivo_firmado;
        nameFile = nombre_archivo_firmado;
        respuest = this.getKeyStore();
        KeyStore keyStore = (KeyStore)respuest.data;
        if (keyStore == null) {
            return respuest;
        }
        String alias = GenericXMLSignature.getAlias(keyStore);
        X509Certificate certificate = null;
        try {
            certificate = (X509Certificate)keyStore.getCertificate(alias);
            if (certificate == null) {
                respuest.estado = false;
                respuest.mensaje = "Error: No existe ning\u00fan certificado para firmar.";
                respuest.data = null;
                return respuest;
            }
        }
        catch (KeyStoreException e1) {
            respuest.estado = false;
            respuest.mensaje = "Error: " + e1.getMessage();
            respuest.data = null;
            return respuest;
        }
        PrivateKey privateKey = null;
        KeyStore tmpKs = keyStore;
        try {
            privateKey = (PrivateKey)tmpKs.getKey(alias, this.passSignature.toCharArray());
        }
        catch (UnrecoverableKeyException e) {
            respuest.estado = false;
            respuest.mensaje = "Error: No existe clave privada para firmar.";
            respuest.data = null;
            return respuest;
        }
        catch (KeyStoreException e) {
            respuest.estado = false;
            respuest.mensaje = "Error: No existe clave privada para firmar.";
            respuest.data = null;
            return respuest;
        }
        catch (NoSuchAlgorithmException e) {
            respuest.estado = false;
            respuest.mensaje = "Error: No existe clave privada para firmar.";
            respuest.data = null;
            return respuest;
        }
        Provider provider = keyStore.getProvider();
        DataToSign dataToSign = this.createDataToSign();
        FirmaXML firma = new FirmaXML();
        Document docSigned = null;
        try {
            Object[] res = firma.signFile(certificate, dataToSign, privateKey, provider);
            docSigned = (Document)res[0];
        }
        catch (Exception ex) {
            respuest.estado = false;
            respuest.mensaje = "Error: " + ex.getMessage();
            respuest.data = null;
            return respuest;
        }
        String filePath = this.getPathOut() + File.separatorChar + this.getSignatureFileName();
        respuest = this.saveDocumenteDisk(docSigned, filePath);
        if (!respuest.estado) {
            return respuest;
        }
        respuest.estado = true;
        respuest.mensaje = "Ok";
        respuest.data = null;
        return respuest;
    }

    protected Document getDocument(String resource) throws IOException {
        Document doc = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        File file = new File(resource);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(file);
        }
        catch (IOException | IllegalArgumentException | ParserConfigurationException | SAXException ex) {
            throw new IOException("Error al parsear el documento: " + ex.getMessage());
        }
        return doc;
    }

    private Respuesta getKeyStore() throws CertificateException, IOException {
        Respuesta respuest = new Respuesta(true, "OK", "");
        KeyStore ks = null;
        try {
            ks = KeyStore.getInstance("PKCS12");
            ks.load(new FileInputStream(this.pathSignature), this.passSignature.toCharArray());
        }
        catch (KeyStoreException e) {
            respuest.estado = false;
            respuest.mensaje = "Error: " + e.getMessage();
            respuest.data = null;
            return respuest;
        }
        catch (NoSuchAlgorithmException e) {
            respuest.estado = false;
            respuest.mensaje = "Error: " + e.getMessage();
            respuest.data = null;
            return respuest;
        }
        catch (CertificateException e) {
            respuest.estado = false;
            respuest.mensaje = "Error: " + e.getMessage();
            respuest.data = null;
            return respuest;
        }
        catch (IOException e) {
            respuest.estado = false;
            respuest.mensaje = "Error: " + e.getMessage();
            respuest.data = null;
            return respuest;
        }
        respuest.data = ks;
        return respuest;
    }

    private static String getAlias(KeyStore keyStore) throws IOException {
        String alias = null;
        try {
            Enumeration<String> nombres = keyStore.aliases();
            while (nombres.hasMoreElements()) {
                String tmpAlias = nombres.nextElement();
                if (!keyStore.isKeyEntry(tmpAlias)) continue;
                alias = tmpAlias;
            }
        }
        catch (KeyStoreException e) {
            throw new IOException("Error: " + e.getMessage());
        }
        return alias;
    }

    public Respuesta saveDocumenteDisk(Document document, String pathXml) throws IOException {
        Respuesta respuest = new Respuesta(true, "OK", "");
        try {
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(new File(pathXml));
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.transform(source, result);
            return respuest;
        }
        catch (TransformerConfigurationException e) {
            respuest.estado = false;
            respuest.mensaje = "Error:" + e.getMessage();
            respuest.data = null;
        }
        catch (TransformerException e) {
            respuest.estado = false;
            respuest.mensaje = "Error:" + e.getMessage();
            respuest.data = null;
        }
        return respuest;
    }

    protected DataToSign createDataToSign() {
        DataToSign datosAFirmar = new DataToSign();
        datosAFirmar.setXadesFormat(EnumFormatoFirma.XAdES_BES);
        datosAFirmar.setEsquema(XAdESSchemas.XAdES_132);
        datosAFirmar.setXMLEncoding("UTF-8");
        datosAFirmar.setEnveloped(true);
        datosAFirmar.addObject(new ObjectToSign((AbstractObjectToSign)new InternObjectToSign("comprobante"), "contenido comprobante", (ObjectIdentifier)null, "text/xml", (URI)null));
        datosAFirmar.setParentSignNode("comprobante");
        Document docToSign = null;
        try {
            docToSign = this.getDocument(this.fileToSign);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        datosAFirmar.setDocument(docToSign);
        return datosAFirmar;
    }

    protected String getSignatureFileName() {
        return nameFile;
    }

    protected String getPathOut() {
        return pathFile;
    }
}

